/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetChanges;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphWrapper;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadAction;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;

public class DatasetGraphMonitor
extends DatasetGraphWrapper {
    private boolean CheckFirst = true;
    private boolean RecordNoAction = true;
    private final DatasetChanges monitor;
    private static int SLICE = 1000;

    public DatasetGraphMonitor(DatasetGraph dsg, DatasetChanges monitor) {
        super(dsg);
        this.monitor = monitor;
    }

    public DatasetGraphMonitor(DatasetGraph dsg, DatasetChanges monitor, boolean recordOnlyIfRealChange) {
        super(dsg);
        this.CheckFirst = recordOnlyIfRealChange;
        this.monitor = monitor;
    }

    public DatasetChanges getMonitor() {
        return this.monitor;
    }

    public DatasetGraph monitored() {
        return this.getWrapped();
    }

    @Override
    public void add(Quad quad) {
        if (this.CheckFirst && this.contains(quad)) {
            if (this.RecordNoAction) {
                this.record(QuadAction.NO_ADD, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
            }
            return;
        }
        this.add$(quad);
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        if (this.CheckFirst && this.contains(g, s, p, o)) {
            if (this.RecordNoAction) {
                this.record(QuadAction.NO_ADD, g, s, p, o);
            }
            return;
        }
        this.add$(g, s, p, o);
    }

    private void add$(Node g, Node s, Node p, Node o) {
        super.add(g, s, p, o);
        this.record(QuadAction.ADD, g, s, p, o);
    }

    private void add$(Quad quad) {
        super.add(quad);
        this.record(QuadAction.ADD, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public void delete(Quad quad) {
        if (this.CheckFirst && !this.contains(quad)) {
            if (this.RecordNoAction) {
                this.record(QuadAction.NO_DELETE, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
            }
            return;
        }
        this.delete$(quad);
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        if (this.CheckFirst && !this.contains(g, s, p, o)) {
            if (this.RecordNoAction) {
                this.record(QuadAction.NO_DELETE, g, s, p, o);
            }
            return;
        }
        this.delete$(g, s, p, o);
    }

    private void delete$(Quad quad) {
        super.delete(quad);
        this.record(QuadAction.DELETE, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    private void delete$(Node g, Node s, Node p, Node o) {
        super.delete(g, s, p, o);
        this.record(QuadAction.DELETE, g, s, p, o);
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        List<Quad> some;
        do {
            Iterator<Quad> iter = this.find(g, s, p, o);
            some = Iter.take(iter, SLICE);
            for (Quad q : some) {
                this.delete$(q);
            }
        } while (some.size() >= SLICE);
    }

    @Override
    public void addGraph(Node gn, Graph g) {
        ExtendedIterator iter = g.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            this.add(gn, t.getSubject(), t.getPredicate(), t.getObject());
        }
    }

    @Override
    public void removeGraph(Node gn) {
        this.deleteAny(gn, Node.ANY, Node.ANY, Node.ANY);
    }

    private void record(QuadAction action, Node g, Node s, Node p, Node o) {
        this.monitor.change(action, g, s, p, o);
    }

    @Override
    public void sync() {
        SystemARQ.syncObject(this.monitor);
        super.sync();
    }
}

