/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModEngine;
import arq.cmdline.ModSymbol;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.SimpleTestRunner;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.vocabulary.DOAP;
import com.hp.hpl.jena.sparql.vocabulary.FOAF;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.langsuite.FactoryTestRiot;
import org.apache.jena.riot.langsuite.VocabLangRDF;

public class rdflangtest
extends CmdGeneral {
    protected ModSymbol modSymbol = new ModSymbol();
    protected ArgDecl strictDecl = new ArgDecl(false, "strict", new String[0]);
    protected boolean cmdStrictMode = false;
    protected ArgDecl earlDecl = new ArgDecl(false, "earl", new String[0]);
    protected boolean createEarlReport = false;
    static String name = "Apache Jena RIOT";
    static String releaseName = "RIOT";
    static String version = null;
    static String homepage = "http://jena.apache.org/";
    static String systemURI = "http://jena.apache.org/#riot";

    public static void main(String ... argv) {
        RIOT.init();
        try {
            new rdflangtest(argv).mainRun();
        }
        catch (TerminationException ex) {
            System.exit(ex.getCode());
        }
    }

    public rdflangtest(String[] argv) {
        super(argv);
        this.addModule((ArgModuleGeneral)this.modSymbol);
        super.add(this.strictDecl, "--strict", "Operate in strict mode (no extensions of any kind)");
        this.modVersion.addClass(ARQ.class);
        this.getUsage().startCategory("Tests (execute test manifest)");
        this.getUsage().addUsage("<manifest>", "run the tests specified in the given manifest");
        this.add(this.earlDecl, "--earl", "create EARL report");
    }

    protected ModEngine setModEngine() {
        return new ModEngine();
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    protected String getSummary() {
        return this.getCommandName() + " [ --data=<file> --query=<query> --result=<results> ] | --all | --dawg | <manifest>";
    }

    protected void processModulesAndArgs() {
        if (!this.hasPositional()) {
            throw new CmdException("No manifest file");
        }
        this.createEarlReport = this.contains(this.earlDecl);
    }

    protected void exec() {
        BaseTest.setTestLogging();
        if (this.contains(this.strictDecl)) {
            this.cmdStrictMode = true;
            ARQ.setStrictMode();
            RIOT.setStrictMode((boolean)true);
        }
        NodeValue.VerboseWarnings = false;
        E_Function.WarnOnUnknownFunction = false;
        for (String fn : this.getPositional()) {
            this.exec1(fn);
        }
    }

    protected void exec1(String manifest) {
        if (this.createEarlReport) {
            rdflangtest.oneManifestEarl(manifest);
        } else {
            rdflangtest.oneManifest(manifest);
        }
    }

    static void oneManifest(String testManifest) {
        TestSuite suite = FactoryTestRiot.make(testManifest, null, null);
        SimpleTestRunner.runAndReport((Test)suite);
    }

    static void oneManifestEarl(String testManifest) {
        EarlReport report;
        FactoryTestRiot.report = report = new EarlReport(systemURI, name, version, homepage);
        TestSuite suite = FactoryTestRiot.make(testManifest, null, null);
        SimpleTestRunner.runSilent((Test)suite);
        Model model = report.getModel();
        model.setNsPrefix("rdft", VocabLangRDF.getURI());
        model.setNsPrefix("turtletest", "http://www.w3.org/2013/TurtleTests/manifest.ttl#");
        rdflangtest.insertMetaOld(report);
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (Lang)Lang.TURTLE);
    }

    static void insertMeta(EarlReport report) {
        Model model = report.getModel();
    }

    static void insertMetaOld(EarlReport report) {
        Model model = report.getModel();
        Resource jena = model.createResource().addProperty(FOAF.homepage, (RDFNode)model.createResource("http://jena.apache.org/"));
        Resource arq = report.getSystem().addProperty(DCTerms.isPartOf, (RDFNode)jena);
        Resource who = model.createResource(FOAF.Person).addProperty(FOAF.name, "Andy Seaborne").addProperty(FOAF.homepage, (RDFNode)model.createResource("http://people.apache.org/~andy"));
        Resource reporter = report.getReporter();
        reporter.addProperty(DC.creator, (RDFNode)who);
        Resource system = report.getSystem();
        system.addProperty(RDF.type, (RDFNode)DOAP.Project);
        system.addProperty(DOAP.name, name);
        system.addProperty(DOAP.homepage, homepage);
        system.addProperty(DOAP.maintainer, (RDFNode)who);
        Resource release = model.createResource(DOAP.Version);
        system.addProperty(DOAP.release, (RDFNode)release);
        Node today_node = NodeFactoryExtra.todayAsDate();
        Literal today = model.createTypedLiteral(today_node.getLiteralLexicalForm(), today_node.getLiteralDatatype());
        release.addProperty(DOAP.created, (RDFNode)today);
        release.addProperty(DOAP.name, releaseName);
    }
}

