/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.writer.AbstractWriterTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRiotWriterGraph
extends AbstractWriterTest {
    private RDFFormat format;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({RDFFormat.RDFNULL}, {RDFFormat.NTRIPLES_UTF8}, {RDFFormat.NTRIPLES_ASCII}, {RDFFormat.NTRIPLES}, {RDFFormat.TURTLE}, {RDFFormat.TURTLE_PRETTY}, {RDFFormat.TURTLE_BLOCKS}, {RDFFormat.TURTLE_FLAT}, {RDFFormat.RDFXML}, {RDFFormat.RDFXML_PRETTY}, {RDFFormat.RDFXML_PLAIN}, {RDFFormat.JSONLD}, {RDFFormat.JSONLD_PRETTY}, {RDFFormat.JSONLD_FLAT}, {RDFFormat.RDFJSON}, {RDFFormat.TRIG}, {RDFFormat.TRIG_PRETTY}, {RDFFormat.TRIG_BLOCKS}, {RDFFormat.TRIG_FLAT}, {RDFFormat.NQUADS_UTF8}, {RDFFormat.NQUADS_ASCII}, {RDFFormat.NQUADS}, {RDFFormat.RDF_THRIFT}, {RDFFormat.RDF_THRIFT_VALUES}, {RDFFormat.TRIX});
    }

    public TestRiotWriterGraph(RDFFormat format) {
        this.format = format;
    }

    @Test
    public void writer00() {
        this.test("writer-rt-00.ttl");
    }

    @Test
    public void writer01() {
        this.test("writer-rt-01.ttl");
    }

    @Test
    public void writer02() {
        this.test("writer-rt-02.ttl");
    }

    @Test
    public void writer03() {
        this.test("writer-rt-03.ttl");
    }

    @Test
    public void writer04() {
        this.test("writer-rt-04.ttl");
    }

    @Test
    public void writer05() {
        this.test("writer-rt-05.ttl");
    }

    @Test
    public void writer06() {
        this.test("writer-rt-06.ttl");
    }

    @Test
    public void writer07() {
        this.test("writer-rt-07.ttl");
    }

    @Test
    public void writer08() {
        this.test("writer-rt-08.ttl");
    }

    @Test
    public void writer09() {
        if (this.format.getLang() != Lang.JSONLD) {
            this.test("writer-rt-09.ttl");
        }
    }

    @Test
    public void writer10() {
        if (this.format.getLang() != Lang.JSONLD) {
            this.test("writer-rt-10.ttl");
        }
    }

    @Test
    public void writer11() {
        this.test("writer-rt-11.ttl");
    }

    @Test
    public void writer12() {
        this.test("writer-rt-12.ttl");
    }

    @Test
    public void writer13() {
        this.test("writer-rt-13.ttl");
    }

    @Test
    public void writer14() {
        this.test("writer-rt-14.ttl");
    }

    @Test
    public void writer15() {
        this.test("writer-rt-15.ttl");
    }

    @Test
    public void writer16() {
        this.test("writer-rt-16.ttl");
    }

    @Test
    public void writer17() {
        this.test("writer-rt-17.ttl");
    }

    private void test(String filename) {
        String displayname = filename.substring(0, filename.lastIndexOf(46));
        Model m = TestRiotWriterGraph.readModel(filename);
        Lang lang = this.format.getLang();
        WriterGraphRIOT rs = RDFWriterRegistry.getWriterGraphFactory((RDFFormat)this.format).create(this.format);
        TestRiotWriterGraph.assertEquals((Object)lang, (Object)rs.getLang());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Model)m, (RDFFormat)this.format);
        if (lang == Lang.RDFNULL) {
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        String s = StrUtils.fromUTF8bytes((byte[])out.toByteArray());
        Model m2 = ModelFactory.createDefaultModel();
        try {
            RDFDataMgr.read((Model)m2, (InputStream)in, (Lang)lang);
        }
        catch (RiotException ex) {
            System.out.println(this.format);
            System.out.println(s);
            throw ex;
        }
        boolean b = m.isIsomorphicWith(m2);
        if (!b) {
            System.out.println("------[" + this.format + "]---------------------------------------------------");
            System.out.println("#### file=" + displayname);
            System.out.print(s);
        }
        TestRiotWriterGraph.assertTrue((String)("Did not round-trip file=" + filename + " / format=" + this.format), (boolean)b);
    }
}

