/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.IsoMatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.writer.AbstractWriterTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRiotWriterDataset
extends AbstractWriterTest {
    private RDFFormat format;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({RDFFormat.RDFNULL}, {RDFFormat.TRIG}, {RDFFormat.TRIG_PRETTY}, {RDFFormat.TRIG_BLOCKS}, {RDFFormat.TRIG_FLAT}, {RDFFormat.JSONLD}, {RDFFormat.JSONLD_PRETTY}, {RDFFormat.JSONLD_FLAT}, {RDFFormat.NQUADS}, {RDFFormat.NQUADS_UTF8}, {RDFFormat.NQUADS_ASCII}, {RDFFormat.RDF_THRIFT}, {RDFFormat.RDF_THRIFT_VALUES}, {RDFFormat.TRIX});
    }

    public TestRiotWriterDataset(RDFFormat format) {
        this.format = format;
    }

    @Test
    public void writer00() {
        this.test("writer-rt-20.trig");
    }

    @Test
    public void writer01() {
        this.test("writer-rt-21.trig");
    }

    @Test
    public void writer02() {
        this.test("writer-rt-22.trig");
    }

    @Test
    public void writer03() {
        this.test("writer-rt-23.trig");
    }

    @Test
    public void writer04() {
        this.test("writer-rt-24.trig");
    }

    @Test
    public void writer05() {
        this.test("writer-rt-25.trig");
    }

    @Test
    public void writer06() {
        this.test("writer-rt-26.trig");
    }

    @Test
    public void writer07() {
        this.test("writer-rt-27.trig");
    }

    @Test
    public void writer08() {
        if (this.format.getLang().equals((Object)Lang.JSONLD)) {
            return;
        }
        this.test("writer-rt-28.trig");
    }

    @Test
    public void writer09() {
        this.test("writer-rt-29.trig");
    }

    @Test
    public void writer10() {
        this.test("writer-rt-30.trig");
    }

    private void test(String filename) {
        String displayname = filename.substring(0, filename.lastIndexOf(46));
        Dataset ds = TestRiotWriterDataset.readDataset(filename);
        Lang lang = this.format.getLang();
        WriterDatasetRIOT rs = RDFWriterRegistry.getWriterDatasetFactory((RDFFormat)this.format).create(this.format);
        TestRiotWriterDataset.assertEquals((Object)lang, (Object)rs.getLang());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Dataset)ds, (RDFFormat)this.format);
        if (lang == Lang.RDFNULL) {
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        String s = StrUtils.fromUTF8bytes((byte[])out.toByteArray());
        Dataset ds2 = DatasetFactory.createMem();
        try {
            RDFDataMgr.read((Dataset)ds2, (InputStream)in, (Lang)lang);
        }
        catch (RiotException ex) {
            System.out.println(displayname + " : " + this.format);
            System.out.println(s);
            throw ex;
        }
        boolean b = IsoMatcher.isomorphic((DatasetGraph)ds.asDatasetGraph(), (DatasetGraph)ds2.asDatasetGraph());
        if (!b) {
            System.out.println("Test: " + this.format.toString());
            System.out.println("-- Input");
            RDFDataMgr.write((OutputStream)System.out, (DatasetGraph)ds.asDatasetGraph(), (Lang)Lang.NQUADS);
            System.out.println("-- Written");
            System.out.println(s);
            System.out.println();
            System.out.println("-- Seen as");
            RDFDataMgr.write((OutputStream)System.out, (DatasetGraph)ds2.asDatasetGraph(), (Lang)Lang.NQUADS);
            System.out.println("-------------");
        }
        TestRiotWriterDataset.assertTrue((String)"Datasets are not isomorphic", (boolean)b);
    }
}

