/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.system.IO_JenaWriters;
import org.apache.jena.riot.writer.AbstractWriterTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestJenaWriters
extends AbstractWriterTest {
    private String jenaFormatName;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> data() {
        RIOT.init();
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        for (String wname : IO_JenaWriters.getJenaWriterNames()) {
            x.add(new Object[]{wname});
        }
        return x;
    }

    public TestJenaWriters(String jenaFormatName) {
        this.jenaFormatName = jenaFormatName;
    }

    @Test
    public void jwrite_00() {
        this.test("writer-jena.ttl");
    }

    private void test(String filename) {
        Model m = TestJenaWriters.readModel(filename);
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out2, (Model)m, (RDFFormat)IO_JenaWriters.getFormatForJenaWriter((String)this.jenaFormatName));
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        m.write((OutputStream)out1, this.jenaFormatName);
        try {
            TestJenaWriters.assertArrayEquals((String)("Format: " + this.jenaFormatName), (byte[])out2.toByteArray(), (byte[])out1.toByteArray());
        }
        catch (AssertionError ex) {
            String s1 = Bytes.bytes2string((byte[])out1.toByteArray());
            String s2 = Bytes.bytes2string((byte[])out2.toByteArray());
            System.out.print(s1);
            System.out.print(s2);
            throw ex;
        }
    }
}

