/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_BNode;
import org.apache.jena.riot.thrift.wire.RDF_IRI;
import org.apache.jena.riot.thrift.wire.RDF_Literal;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.junit.Test;

public class TestThriftTerm
extends BaseTest {
    static PrefixMap prefixMap = PrefixMapFactory.create();

    @Test
    public void term_uri_01() {
        this.testTerm("<http://hostname/>");
    }

    @Test
    public void term_uri_02() {
        RDF_Term rt = this.testTerm("<http://example/>");
        TestThriftTerm.assertTrue((boolean)rt.isSetPrefixName());
        TestThriftTerm.assertEquals((Object)rt.getPrefixName().prefix, (Object)"");
        TestThriftTerm.assertEquals((Object)rt.getPrefixName().localName, (Object)"");
    }

    @Test
    public void term_uri_03() {
        RDF_Term rt = this.testTerm("<http://namespace/ns#foobar>");
        TestThriftTerm.assertTrue((boolean)rt.isSetPrefixName());
        TestThriftTerm.assertEquals((Object)rt.getPrefixName().prefix, (Object)"ns");
        TestThriftTerm.assertEquals((Object)rt.getPrefixName().localName, (Object)"foobar");
    }

    @Test
    public void term_uri_04() {
        RDF_Term rt = this.testTerm("rdf:type");
        TestThriftTerm.assertTrue((boolean)rt.isSetPrefixName());
        TestThriftTerm.assertEquals((Object)rt.getPrefixName().prefix, (Object)"rdf");
        TestThriftTerm.assertEquals((Object)rt.getPrefixName().localName, (Object)"type");
    }

    @Test
    public void term_literal_01() {
        this.testTerm("'foo'");
    }

    @Test
    public void term_literal_02() {
        this.testTerm("'foo'@en");
    }

    @Test
    public void term_literal_03() {
        RDF_Term rt = this.testTerm("123");
        TestThriftTerm.assertFalse((boolean)rt.getLiteral().isSetDatatype());
        TestThriftTerm.assertTrue((boolean)rt.getLiteral().isSetDtPrefix());
        TestThriftTerm.assertEquals((Object)rt.getLiteral().getDtPrefix().getPrefix(), (Object)"xsd");
        TestThriftTerm.assertEquals((Object)rt.getLiteral().getDtPrefix().getLocalName(), (Object)"integer");
    }

    @Test
    public void term_literal_04() {
        RDF_Term rt = this.testTerm("'foo'^^<http://dataype/>");
        TestThriftTerm.assertTrue((boolean)rt.getLiteral().isSetDatatype());
        TestThriftTerm.assertFalse((boolean)rt.getLiteral().isSetDtPrefix());
        TestThriftTerm.assertEquals((Object)rt.getLiteral().getDatatype(), (Object)"http://dataype/");
    }

    @Test
    public void term_literal_05() {
        RDF_Term rt = this.testTerm("'foo'^^<http://example/>");
        TestThriftTerm.assertFalse((boolean)rt.getLiteral().isSetDatatype());
        TestThriftTerm.assertTrue((boolean)rt.getLiteral().isSetDtPrefix());
        TestThriftTerm.assertEquals((Object)rt.getLiteral().getDtPrefix().getPrefix(), (Object)"");
        TestThriftTerm.assertEquals((Object)rt.getLiteral().getDtPrefix().getLocalName(), (Object)"");
    }

    @Test
    public void term_var_01() {
        this.testTerm("?var");
    }

    @Test
    public void term_bnode_01() {
        Node n = SSE.parseNode((String)"_:blanknode");
        RDF_Term rt = this.testTerm(n);
        TestThriftTerm.assertEquals((Object)rt.getBnode().getLabel(), (Object)n.getBlankNodeLabel());
    }

    @Test
    public void term_bnode_02() {
        String label = "abcdefghijklmn";
        Node n = NodeFactory.createAnon((AnonId)new AnonId("abcdefghijklmn"));
        RDF_Term rt = this.testTerm(n);
        TestThriftTerm.assertTrue((boolean)rt.isSetBnode());
        TestThriftTerm.assertEquals((Object)"abcdefghijklmn", (Object)rt.getBnode().getLabel());
    }

    @Test
    public void term_any_1() {
        RDF_Term rt = this.testTerm(Node.ANY);
        TestThriftTerm.assertTrue((boolean)rt.isSetAny());
    }

    @Test
    public void term_value_01() {
        RDF_Term rt = this.testTermValue("123");
        TestThriftTerm.assertTrue((boolean)rt.isSetValInteger());
        TestThriftTerm.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_02() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:integer");
        TestThriftTerm.assertTrue((boolean)rt.isSetValInteger());
        TestThriftTerm.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_03() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:long");
        TestThriftTerm.assertTrue((boolean)rt.isSetValInteger());
        TestThriftTerm.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_04() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:int");
        TestThriftTerm.assertTrue((boolean)rt.isSetValInteger());
        TestThriftTerm.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_05() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:short");
        TestThriftTerm.assertTrue((boolean)rt.isSetValInteger());
        TestThriftTerm.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_06() {
        RDF_Term rt = this.testTermValue("'123'^^xsd:byte");
        TestThriftTerm.assertTrue((boolean)rt.isSetValInteger());
        TestThriftTerm.assertEquals((long)123L, (long)rt.getValInteger());
    }

    @Test
    public void term_value_10() {
        RDF_Term rt = this.testTermValue("123.6");
        TestThriftTerm.assertTrue((boolean)rt.isSetValDecimal());
        TestThriftTerm.assertEquals((long)1236L, (long)rt.getValDecimal().getValue());
        TestThriftTerm.assertEquals((long)1L, (long)rt.getValDecimal().getScale());
    }

    @Test
    public void term_value_11() {
        RDF_Term rt = this.testTermValue("0.005");
        TestThriftTerm.assertTrue((boolean)rt.isSetValDecimal());
        TestThriftTerm.assertEquals((long)5L, (long)rt.getValDecimal().getValue());
        TestThriftTerm.assertEquals((long)3L, (long)rt.getValDecimal().getScale());
    }

    @Test
    public void term_value_12() {
        RDF_Term rt = this.testTermValue("50.0");
        TestThriftTerm.assertTrue((boolean)rt.isSetValDecimal());
        TestThriftTerm.assertEquals((long)500L, (long)rt.getValDecimal().getValue());
        TestThriftTerm.assertEquals((long)1L, (long)rt.getValDecimal().getScale());
    }

    @Test
    public void term_value_13() {
        RDF_Term rt = this.testTermValue("50.05");
        TestThriftTerm.assertTrue((boolean)rt.isSetValDecimal());
        TestThriftTerm.assertEquals((long)5005L, (long)rt.getValDecimal().getValue());
        TestThriftTerm.assertEquals((long)2L, (long)rt.getValDecimal().getScale());
    }

    @Test
    public void term_value_20() {
        RDF_Term rt = this.testTermValue("50e6");
        TestThriftTerm.assertTrue((boolean)rt.isSetValDouble());
        TestThriftTerm.assertEquals((double)5.0E7, (double)rt.getValDouble(), (double)0.001);
    }

    @Test
    public void term_value_21() {
        RDF_Term rt = this.testTermValue("50e-6");
        TestThriftTerm.assertTrue((boolean)rt.isSetValDouble());
        TestThriftTerm.assertEquals((double)5.0E-5, (double)rt.getValDouble(), (double)1000.0);
    }

    private RDF_Term testTermValue(String str) {
        RDF_Term rt = this.testTerm(SSE.parseNode((String)str), prefixMap, true);
        return rt;
    }

    private RDF_Term testTerm(String str) {
        RDF_Term rt = this.testTerm(SSE.parseNode((String)str), prefixMap, false);
        return rt;
    }

    private RDF_Term testTerm(Node node) {
        return this.testTerm(node, null, false);
    }

    private RDF_Term testTerm(Node node, PrefixMap pmap, boolean asValue) {
        RDF_Term rt = ThriftConvert.convert((Node)node, (PrefixMap)pmap, (boolean)asValue);
        TestThriftTerm.assertTrue((boolean)rt.isSet());
        if (node == null) {
            TestThriftTerm.assertTrue((boolean)rt.isSetUndefined());
        } else if (node.isURI()) {
            TestThriftTerm.assertTrue((rt.isSetIri() || rt.isSetPrefixName() ? 1 : 0) != 0);
            if (rt.isSetIri()) {
                RDF_IRI iri = rt.getIri();
                TestThriftTerm.assertEquals((Object)node.getURI(), (Object)iri.getIri());
            }
            if (rt.isSetPrefixName()) {
                TestThriftTerm.assertTrue((boolean)rt.getPrefixName().isSetPrefix());
                TestThriftTerm.assertTrue((boolean)rt.getPrefixName().isSetLocalName());
            }
        } else {
            if (rt.isSetValDecimal() || rt.isSetValDouble() || rt.isSetValInteger()) {
                return rt;
            }
            if (node.isLiteral()) {
                TestThriftTerm.assertTrue((boolean)rt.isSetLiteral());
                RDF_Literal lit = rt.getLiteral();
                TestThriftTerm.assertTrue((boolean)lit.isSetLex());
                TestThriftTerm.assertEquals((Object)node.getLiteralLexicalForm(), (Object)lit.getLex());
                if (node.getLiteralDatatype() != null) {
                    TestThriftTerm.assertTrue((lit.isSetDatatype() || lit.isSetDtPrefix() ? 1 : 0) != 0);
                }
            } else if (node.isBlank()) {
                TestThriftTerm.assertTrue((boolean)rt.isSetBnode());
                RDF_BNode bnode = rt.getBnode();
                TestThriftTerm.assertEquals((Object)node.getBlankNodeLabel(), (Object)bnode.getLabel());
            } else if (node.isVariable()) {
                TestThriftTerm.assertTrue((boolean)rt.isSetVariable());
                TestThriftTerm.assertEquals((Object)node.getName(), (Object)rt.getVariable().getName());
            } else if (Node.ANY.equals((Object)node)) {
                TestThriftTerm.assertTrue((boolean)rt.isSetAny());
            } else {
                TestThriftTerm.fail((String)"Unknown node type");
            }
        }
        Node n2 = ThriftConvert.convert((RDF_Term)rt, (PrefixMap)pmap);
        TestThriftTerm.assertEquals((Object)node, (Object)n2);
        return rt;
    }

    @Test
    public void rdfterm_01() {
        RDF_Term rt = TRDF.tANY;
        Node n = ThriftConvert.convert((RDF_Term)rt);
        TestThriftTerm.assertEquals((Object)Node.ANY, (Object)n);
    }

    @Test
    public void rdfterm_02() {
        RDF_Term rt = TRDF.tUNDEF;
        Node n = ThriftConvert.convert((RDF_Term)rt);
        TestThriftTerm.assertNull((Object)n);
    }

    @Test
    public void round_trip_01() {
        this.testTerm(null, null, false);
    }

    @Test
    public void round_trip_02() {
        this.testTerm(Node.ANY, null, false);
    }

    @Test
    public void round_trip_03() {
        this.testTerm(NodeFactory.createVariable((String)"x"), null, false);
    }

    static {
        prefixMap.add("rdf", RDF.getURI());
        prefixMap.add("xsd", XSD.getURI());
        prefixMap.add("rdfs", RDFS.getURI());
        prefixMap.add("ex", "http://example.org/");
        prefixMap.add("", "http://example/");
        prefixMap.add("ns", "http://namespace/ns#");
    }
}

