/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.sparql.resultset.ResultSetCompare;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderResultSet;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.thrift.BinRDF;
import org.junit.Test;

public class TestResultSetThrift
extends BaseTest {
    static ResultSetRewindable rs0 = TestResultSetThrift.make("(resultset (?x ?y)", "   (row (?x _:a) (?y 3))", "   (row (?x 1) (?y 'a'))", "   (row (?y 'y'))", "   (row (?x _:a))", "   (row)", "   (row (?x 2) (?y 10))", ")");
    static ResultSetRewindable rs1 = TestResultSetThrift.make("(resultset (?x ?y)", "   (row (?x 1) (?y 3))", "   (row (?x 1) (?y 'a'))", ")");
    static ResultSetRewindable rs2 = TestResultSetThrift.make("(resultset (?x ?y)", "   (row (?x 1) (?y 'a'))", "   (row (?x 1) (?y 3))", ")");
    private static NodeUtils.EqualityTest exactTest = new EqualityTestExact();
    private static final String DIR = "testing/RIOT/RDF-Thrift";

    @Test
    public void resultSet_01() {
        TestResultSetThrift.test(rs0);
    }

    @Test
    public void resultSet_02() {
        ResultSetRewindable r1 = TestResultSetThrift.test(rs1);
        r1.reset();
        rs2.reset();
        TestResultSetThrift.assertFalse((boolean)ResultSetCompare.equalsByTermAndOrder((ResultSet)r1, (ResultSet)rs2));
        rs2.reset();
    }

    @Test
    public void resultSet_03() {
        ResultSetRewindable r2 = TestResultSetThrift.test(rs2);
        r2.reset();
        rs1.reset();
        TestResultSetThrift.assertFalse((boolean)ResultSetCompare.equalsByTermAndOrder((ResultSet)r2, (ResultSet)rs1));
        rs1.reset();
    }

    private static ResultSetRewindable test(ResultSetRewindable resultSet) {
        resultSet.reset();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinRDF.writeResultSet((OutputStream)out, (ResultSet)resultSet, (boolean)true);
        resultSet.reset();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs$ = BinRDF.readResultSet((InputStream)in);
        ResultSetRewindable resultSet2 = ResultSetFactory.makeRewindable((ResultSet)rs$);
        ResultSetCompare.equalsExact((ResultSet)resultSet, (ResultSet)resultSet2);
        resultSet.reset();
        resultSet2.reset();
        return resultSet2;
    }

    private static ResultSetRewindable make(String ... strings) {
        String s = StrUtils.strjoinNL((String[])strings);
        Item item = SSE.parse((String)s);
        ResultSetRewindable rs = ResultSetFactory.makeRewindable((ResultSet)BuilderResultSet.build((Item)item));
        return rs;
    }

    @Test
    public void resultSet_10() {
        try (InputStream in = IO.openFile((String)"testing/RIOT/RDF-Thrift/results-1.srj");){
            ResultSet rs = ResultSetFactory.fromJSON((InputStream)in);
            TestResultSetThrift.test(ResultSetFactory.copyResults((ResultSet)rs));
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    static class EqualityTestExact
    implements NodeUtils.EqualityTest {
        EqualityTestExact() {
        }

        public boolean equal(Node n1, Node n2) {
            return n1.equals((Object)n2);
        }
    }
}

