/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.adapters.JenaReadersWriters;
import org.apache.jena.riot.adapters.RDFReaderRIOT_Web;
import org.apache.jena.riot.system.IO_JenaReaders;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIO_JenaReaders {
    @BeforeClass
    public static void beforeClass() {
    }

    @AfterClass
    public static void afterClass() {
        IO_Jena.wireIntoJena();
    }

    @Test
    public void wireIntoJena() throws Exception {
        IO_JenaReaders.wireIntoJena();
        RDFReaderFImpl readerF = new RDFReaderFImpl();
        Assert.assertEquals(RDFReaderRIOT_Web.class, readerF.getReader().getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_RDFXML.class, readerF.getReader("RDF/XML").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_RDFXML.class, readerF.getReader("RDF/XML-ABBREV").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_NT.class, readerF.getReader("N-TRIPLES").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_NT.class, readerF.getReader("N-Triples").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_NT.class, readerF.getReader("N-TRIPLE").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_TTL.class, readerF.getReader("N3").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_TTL.class, readerF.getReader("TURTLE").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_TTL.class, readerF.getReader("Turtle").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_TTL.class, readerF.getReader("TTL").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_JSONLD.class, readerF.getReader("JSON-LD").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_JSONLD.class, readerF.getReader("JSONLD").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFReaderRIOT_RDFJSON.class, readerF.getReader("RDF/JSON").getClass());
    }

    @Test
    public void resetJena() throws Exception {
        IO_JenaReaders.wireIntoJena();
        IO_JenaReaders.resetJena();
        RDFReaderFImplExposingProtected readerF = new RDFReaderFImplExposingProtected();
        Map<String, String> defaults = readerF.defaultReaders();
        Assert.assertFalse((boolean)defaults.isEmpty());
        for (String lang : defaults.keySet()) {
            Assert.assertEquals((Object)defaults.get(lang), (Object)readerF.getLangToClassName().get(lang));
            if (lang.equals("GRDDL")) continue;
            Assert.assertEquals((Object)defaults.get(lang), (Object)readerF.getReader(lang).getClass().getName());
        }
        Assert.assertEquals((Object)"", (Object)readerF.getLangToClassName().get("JSON-LD"));
        Assert.assertEquals((Object)"", (Object)readerF.getLangToClassName().get("RDF/JSON"));
        IO_JenaReaders.wireIntoJena();
    }

    private final class RDFReaderFImplExposingProtected
    extends RDFReaderFImpl {
        private RDFReaderFImplExposingProtected() {
        }

        public Map<String, String> defaultReaders() {
            LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>();
            for (int i = 0; i < LANGS.length; ++i) {
                defaults.put(LANGS[i], DEFAULTREADERS[i]);
            }
            return defaults;
        }

        public Properties getLangToClassName() {
            return langToClassName;
        }
    }
}

