/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.sparql.resultset.ResultSetCompare;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderResultSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResultSetIO
extends BaseTest {
    static String rsStr = StrUtils.strjoinNL((String[])new String[]{"(resultset (?x ?y)", "   (row (?x _:b0) (?y _:b1))", "   (row (?x _:b2) (?y _:b3))", "   (row (?x _:b1) (?y _:b0))", "   (row (?x 1)           )", "   (row           (?y 2) )", "   (row )", ")"});
    static ResultSetRewindable test_rs = ResultSetFactory.makeRewindable((ResultSet)BuilderResultSet.build((Item)SSE.parse((String)rsStr)));
    private final Lang lang;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        Lang[] langs = new Lang[]{ResultSetLang.SPARQLResultSetXML, ResultSetLang.SPARQLResultSetJSON, ResultSetLang.SPARQLResultSetCSV, ResultSetLang.SPARQLResultSetTSV};
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        for (Lang lang : langs) {
            x.add(new Object[]{"test:" + lang.getName(), lang});
        }
        return x;
    }

    @Before
    public void beforetest() {
        test_rs.reset();
    }

    public TestResultSetIO(String name, Lang lang) {
        this.lang = lang;
    }

    @Test
    public void test_resultset_01() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ResultSetMgr.write((OutputStream)out, (ResultSet)test_rs, (Lang)this.lang);
        test_rs.reset();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs = ResultSetMgr.read((InputStream)in, (Lang)this.lang);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable((ResultSet)rs);
        if (!this.lang.equals((Object)ResultSetLang.SPARQLResultSetCSV)) {
            TestResultSetIO.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)test_rs, (ResultSet)rsw));
        }
        rsw.reset();
        test_rs.reset();
        out = new ByteArrayOutputStream();
        ResultSetMgr.write((OutputStream)out, (ResultSet)rsw, (Lang)this.lang);
        in = new ByteArrayInputStream(out.toByteArray());
        ResultSet rs2 = ResultSetMgr.read((InputStream)in, (Lang)this.lang);
        TestResultSetIO.assertTrue((boolean)ResultSetCompare.equalsByTerm((ResultSet)rsw, (ResultSet)rs2));
    }
}

