/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.langsuite;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.util.IsoMatcher;
import java.io.OutputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.langsuite.LangTestCase;

public class UnitTestEval
extends LangTestCase {
    String input;
    String output;
    String baseIRI;
    Lang lang;

    public UnitTestEval(String name, String testURI, String input, String output, String baseIRI, Lang lang, EarlReport earl) {
        super(name, testURI, earl);
        this.input = input;
        this.output = output;
        this.baseIRI = baseIRI;
        this.lang = lang;
    }

    @Override
    protected void _setUp() {
    }

    @Override
    protected void _tearDown() {
    }

    @Override
    public void runTestForReal() {
        if (RDFLanguages.isTriples((Lang)this.lang)) {
            this.run3();
        } else {
            this.run4();
        }
    }

    private void run4() {
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        try {
            if (this.baseIRI != null) {
                RDFDataMgr.read((DatasetGraph)dsg, (String)this.input, (String)this.baseIRI, (Lang)this.lang);
            } else {
                RDFDataMgr.read((DatasetGraph)dsg, (String)this.input, (Lang)this.lang);
            }
            Lang outLang = RDFLanguages.filenameToLang((String)this.output, (Lang)Lang.NQUADS);
            DatasetGraph results = DatasetGraphFactory.createMem();
            try {
                RDFDataMgr.read((DatasetGraph)results, (String)this.output, (Lang)outLang);
            }
            catch (RiotException ex) {
                UnitTestEval.fail((String)("Failed to read results: " + ex.getMessage()));
            }
            boolean b = this.isomorphic(dsg, results);
            if (!b) {
                System.out.println("**** Test: " + this.getName());
                System.out.println("---- Parsed");
                RDFDataMgr.write((OutputStream)System.out, (DatasetGraph)dsg, (Lang)Lang.TRIG);
                System.out.println("---- Expected");
                RDFDataMgr.write((OutputStream)System.out, (DatasetGraph)results, (Lang)Lang.TRIG);
                System.out.println("--------");
            }
            UnitTestEval.assertTrue((String)"Datasets not isomorphic", (boolean)b);
        }
        catch (RiotException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    private boolean isomorphic(DatasetGraph dsg1, DatasetGraph dsg2) {
        return IsoMatcher.isomorphic((DatasetGraph)dsg1, (DatasetGraph)dsg2);
    }

    private void run3() {
        Model model = ModelFactory.createDefaultModel();
        try {
            if (this.baseIRI != null) {
                RDFDataMgr.read((Model)model, (String)this.input, (String)this.baseIRI, (Lang)this.lang);
            } else {
                RDFDataMgr.read((Model)model, (String)this.input, (Lang)this.lang);
            }
            Lang outLang = RDFLanguages.filenameToLang((String)this.output, (Lang)Lang.NQUADS);
            Model results = ModelFactory.createDefaultModel();
            try {
                RDFDataMgr.read((Model)results, (String)this.output, (Lang)outLang);
            }
            catch (RiotException ex) {
                UnitTestEval.fail((String)("Failed to read results: " + ex.getMessage()));
            }
            boolean b = model.isIsomorphicWith(results);
            if (!b) {
                System.out.println("---- Parsed");
                model.write((OutputStream)System.out, "TTL");
                System.out.println("---- Expected");
                results.write((OutputStream)System.out, "TTL");
                System.out.println("--------");
            }
            UnitTestEval.assertTrue((String)"Models not isomorphic", (boolean)b);
        }
        catch (RiotException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }
}

