/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.langsuite;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.langsuite.LangTestCase;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;

public class UnitTestBadSyntax
extends LangTestCase {
    private final String uri;
    private final Lang lang;
    private static ErrorHandler errorHandlerTestStrict = new ErrorHandler(){

        public void warning(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage((String)message, (long)line, (long)col));
        }

        public void error(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage((String)message, (long)line, (long)col));
        }

        public void fatal(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage((String)message, (long)line, (long)col));
        }
    };

    protected UnitTestBadSyntax(String name, String testURI, String uri, Lang lang, EarlReport earl) {
        super(name, testURI, earl);
        this.uri = uri;
        this.lang = lang;
    }

    @Override
    protected void _setUp() {
        BaseTest.setTestLogging(ErrorHandlerFactory.errorHandlerStrictNoLogging);
    }

    @Override
    protected void _tearDown() {
        BaseTest.unsetTestLogging();
    }

    @Override
    public void runTestForReal() {
        if (RDFLanguages.isTriples((Lang)this.lang)) {
            this.run3();
        } else {
            this.run4();
        }
    }

    private void run3() {
        Model model = ModelFactory.createDefaultModel();
        try {
            RDFDataMgr.read((Model)model, (String)this.uri, (String)this.uri, (Lang)this.lang);
        }
        catch (RiotException ex) {
            return;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            UnitTestBadSyntax.fail((String)"Unexpected exception");
        }
        UnitTestBadSyntax.fail((String)"Bad syntax test succeed in parsing the file");
    }

    private void run4() {
        Dataset ds = DatasetFactory.createMem();
        try {
            RDFDataMgr.read((Dataset)ds, (String)this.uri, (String)this.uri, (Lang)this.lang);
        }
        catch (RiotException ex) {
            return;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            UnitTestBadSyntax.fail((String)"Unexpected exception");
        }
        UnitTestBadSyntax.fail((String)"Bad syntax test succeed in parsing the file");
    }
}

