/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.LangTriG;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.junit.Test;

public class TestParserFactory
extends BaseTest {
    @Test
    public void ntriples_01() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> .");
        CatchParserOutput sink = new CatchParserOutput();
        LangNTriples parser = RiotReader.createParserNTriples((Tokenizer)tokenizer, (StreamRDF)sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)0L, (long)sink.quads.size());
        TestParserFactory.assertEquals((Object)SSE.parseTriple((String)"(<x> <p> <q>)"), (Object)TestParserFactory.last(sink.triples));
    }

    @Test
    public void turtle_01() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> .");
        CatchParserOutput sink = new CatchParserOutput();
        LangTurtle parser = RiotReader.createParserTurtle((Tokenizer)tokenizer, (String)"http://base/", (StreamRDF)sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)0L, (long)sink.quads.size());
        TestParserFactory.assertEquals((Object)SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)"), (Object)TestParserFactory.last(sink.triples));
    }

    @Test
    public void nquads_01() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> <g>.");
        CatchParserOutput sink = new CatchParserOutput();
        LangNQuads parser = RiotReader.createParserNQuads((Tokenizer)tokenizer, (StreamRDF)sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)1L, (long)sink.quads.size());
        Quad q = SSE.parseQuad((String)"(<g> <x> <p> <q>)");
        TestParserFactory.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    @Test
    public void trig_01() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"{ <x> <p> <q> }");
        CatchParserOutput sink = new CatchParserOutput();
        LangTriG parser = RiotReader.createParserTriG((Tokenizer)tokenizer, (String)"http://base/", (StreamRDF)sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)1L, (long)sink.quads.size());
        Triple t = SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)");
        Quad q = new Quad(Quad.tripleInQuad, t);
        TestParserFactory.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    @Test
    public void trig_02() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<g> { <x> <p> <q> }");
        CatchParserOutput sink = new CatchParserOutput();
        LangTriG parser = RiotReader.createParserTriG((Tokenizer)tokenizer, (String)"http://base/", (StreamRDF)sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.startCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.finishCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.triples.size());
        TestParserFactory.assertEquals((long)1L, (long)sink.quads.size());
        Quad q = SSE.parseQuad((String)"(<http://base/g> <http://base/x> <http://base/p> <http://base/q>)");
        TestParserFactory.assertEquals((Object)q, (Object)TestParserFactory.last(sink.quads));
    }

    private static <T> T last(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private static void parserSetup(LangRIOT parser) {
    }

    static class CatchParserOutput
    implements StreamRDF {
        List<Triple> triples = new ArrayList<Triple>();
        List<Quad> quads = new ArrayList<Quad>();
        List<Pair<String, String>> prefixes = new ArrayList<Pair<String, String>>();
        List<String> bases = new ArrayList<String>();
        int startCalled = 0;
        int finishCalled = 0;

        CatchParserOutput() {
        }

        public void start() {
            ++this.startCalled;
        }

        public void triple(Triple triple) {
            this.triples.add(triple);
        }

        public void quad(Quad quad) {
            this.quads.add(quad);
        }

        public void base(String base) {
            this.bases.add(base);
        }

        public void prefix(String prefix, String iri) {
            this.prefixes.add((Pair<String, String>)Pair.create((Object)prefix, (Object)iri));
        }

        public void finish() {
            ++this.finishCalled;
        }
    }
}

