/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLangTurtle
extends BaseTest {
    private static ErrorHandler errorhandler = null;

    @Test
    public void blankNodes1() {
        String s = "_:a <http://example/p> 'foo' . ";
        StringReader r = new StringReader(s);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m, (StringReader)r, null, (Lang)RDFLanguages.TURTLE);
        TestLangTurtle.assertEquals((long)1L, (long)m.size());
        String x = ((Statement)m.listStatements().next()).getSubject().getId().getLabelString();
        TestLangTurtle.assertNotEquals((Object)x, (Object)"a");
        r = new StringReader(s);
        RDFDataMgr.read((Model)m, (StringReader)r, null, (Lang)RDFLanguages.TURTLE);
        TestLangTurtle.assertEquals((long)2L, (long)m.size());
    }

    @Test
    public void blankNodes2() {
        String s = "_:a <http://example/p> 'foo' . _:a <http://example/p> 'foo' .";
        StringReader r = new StringReader(s);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m, (StringReader)r, null, (Lang)RDFLanguages.TURTLE);
        TestLangTurtle.assertEquals((long)1L, (long)m.size());
    }

    @Test
    public void updatePrefixMapping1() {
        Model model = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader("@prefix x: <http://example/x>.");
        RDFDataMgr.read((Model)model, (StringReader)reader, null, (Lang)RDFLanguages.TURTLE);
        TestLangTurtle.assertEquals((long)1L, (long)model.getNsPrefixMap().size());
        TestLangTurtle.assertEquals((Object)"http://example/x", (Object)model.getNsPrefixURI("x"));
    }

    @Test
    public void updatePrefixMapping2() {
        Model model = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader("BASE <http://example/> PREFIX x: <abc>");
        RDFDataMgr.read((Model)model, (StringReader)reader, null, (Lang)RDFLanguages.TURTLE);
        TestLangTurtle.assertEquals((long)1L, (long)model.getNsPrefixMap().size());
        TestLangTurtle.assertEquals((Object)"http://example/abc", (Object)model.getNsPrefixURI("x"));
    }

    @Test
    public void optionalDotInPrefix() {
        Model model = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader("@prefix x: <http://example/x>");
        RDFDataMgr.read((Model)model, (StringReader)reader, null, (Lang)RDFLanguages.TURTLE);
        TestLangTurtle.assertEquals((long)1L, (long)model.getNsPrefixMap().size());
        TestLangTurtle.assertEquals((Object)"http://example/x", (Object)model.getNsPrefixURI("x"));
    }

    @Test
    public void optionalDotInBase() {
        Model model = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader("@base <http://example/> <x> <p> <o> .");
        RDFDataMgr.read((Model)model, (StringReader)reader, null, (Lang)RDFLanguages.TURTLE);
        TestLangTurtle.assertEquals((long)1L, (long)model.size());
        Resource r = model.createResource("http://example/x");
        Property p = model.createProperty("http://example/p");
        TestLangTurtle.assertTrue((boolean)model.contains(r, p));
    }

    @BeforeClass
    public static void beforeClass() {
        errorhandler = ErrorHandlerFactory.getDefaultErrorHandler();
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)ErrorHandlerFactory.errorHandlerNoLogging);
    }

    @AfterClass
    public static void afterClass() {
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)errorhandler);
    }

    private static Graph parse(String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        StringReader reader = new StringReader(string);
        String baseIRI = "http://base/";
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer((Reader)reader);
        Graph graph = GraphFactory.createDefaultGraph();
        StreamRDF sink = StreamRDFLib.graph((Graph)graph);
        LangTurtle parser = RiotReader.createParserTurtle((Tokenizer)tokenizer, (String)"http://base/", (StreamRDF)sink);
        parser.getProfile().setHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
        parser.parse();
        return graph;
    }

    private static Triple parseOneTriple(String ... strings) {
        Graph graph = TestLangTurtle.parse(strings);
        TestLangTurtle.assertEquals((long)1L, (long)graph.size());
        return (Triple)graph.find(null, null, null).next();
    }

    @Test
    public void triple() {
        TestLangTurtle.parse("<s> <p> <o> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorJunk_1() {
        TestLangTurtle.parse("<p>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorJunk_2() {
        TestLangTurtle.parse("<r> <p>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorNoPrefixDef() {
        TestLangTurtle.parse("x:p <p> 'q' .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorNoPrefixDefDT() {
        TestLangTurtle.parse("<p> <p> 'q'^^x:foo .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorBadDatatype() {
        TestLangTurtle.parse("<p> <p> 'q'^^.");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void errorBadURI_1() {
        TestLangTurtle.parse("<http://example/a b> <http://example/p> 123 .");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void errorBadURI_2() {
        TestLangTurtle.parse("<http://example/a%XAb> <http://example/p> 123 .");
    }

    @Test
    public void errorBadURI_3() {
        TestLangTurtle.parse("<http://example/a%Aab> <http://example/p> 123 .");
    }

    @Test
    public void turtle_01() {
        Triple t = TestLangTurtle.parseOneTriple("<s> <p> 123 . ");
        Triple t2 = SSE.parseTriple((String)"(<http://base/s> <http://base/p> 123)");
        TestLangTurtle.assertEquals((Object)t2, (Object)t);
    }

    @Test
    public void turtle_02() {
        Triple t = TestLangTurtle.parseOneTriple("@base <http://example/> . <s> <p> 123 . ");
        Triple t2 = SSE.parseTriple((String)"(<http://example/s> <http://example/p> 123)");
        TestLangTurtle.assertEquals((Object)t2, (Object)t);
    }

    @Test
    public void turtle_03() {
        Triple t = TestLangTurtle.parseOneTriple("@prefix ex: <http://example/x/> . ex:s ex:p 123 . ");
        Triple t2 = SSE.parseTriple((String)"(<http://example/x/s> <http://example/x/p> 123)");
        TestLangTurtle.assertEquals((Object)t2, (Object)t);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void turtle_10() {
        TestLangTurtle.parse("@prefix ex:  <http://example/> .  { ex:s ex:p 123 . } ");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void turtle_20() {
        TestLangTurtle.parse("@prefix ex:  <bad iri> .  ex:s ex:p 123 ");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void turtle_21() {
        TestLangTurtle.parse("@prefix ex:  <http://example/> . ex:s <http://example/broken p> 123");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void turtle_22() {
        TestLangTurtle.parse("<x> <p> 'number'^^<bad uri> ");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void turtle_23() {
        TestLangTurtle.parse("@prefix xsd:  <http://www.w3.org/2001/XMLSchema#> . <x> <p> 'number'^^xsd:byte }");
    }
}

