/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.junit.Test;

public abstract class TestLangNTuples
extends BaseTest {
    @Test
    public void tuple_0() {
        long count = this.parseCount("");
        TestLangNTuples.assertEquals((long)0L, (long)count);
    }

    @Test
    public void tuple_1() {
        long count = this.parseCount("<x> <y> <z>.");
        TestLangNTuples.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_2() {
        long count = this.parseCount("<x> <y> \"z\".");
        TestLangNTuples.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_3() {
        long count = this.parseCount("<x> <y> <z>. <x> <y> <z>.");
        TestLangNTuples.assertEquals((long)2L, (long)count);
    }

    @Test
    public void tuple_4() {
        long count = this.parseCount("<x> <y> \"123\"^^<int>.");
        TestLangNTuples.assertEquals((long)1L, (long)count);
    }

    @Test
    public void tuple_5() {
        long count = this.parseCount("<x> <y> \"123\"@lang.");
        TestLangNTuples.assertEquals((long)1L, (long)count);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_01() {
        this.parseCount("<x> <y> <z>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_02() {
        this.parseCount("<x> _:a <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_03() {
        this.parseCount("<x> \"p\" <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_4() {
        this.parseCount("\"x\" <p> <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_5() {
        this.parseCount("<x> <p> ?var .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_6() {
        this.parseCount("<x> <p> 123 .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void tuple_bad_7() {
        this.parseCount("<x> <p> x:y .");
    }

    @Test
    public void tuple_bad_10() {
        this.parseCount("<x> <p> <bad uri> .");
    }

    @Test
    public void tuple_bad_11() {
        this.parseCount("<x> <p> \"9000\"^^<http://www.w3.org/2001/XMLSchema#byte> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void tuple_bad_21() {
        this.parseCheck("<x> <p> <z> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void tuple_bad_22() {
        this.parseCheck("<http://example/x> <http://example/p> <http://example/bad uri> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void tuple_bad_23() {
        this.parseCheck("<http://example/x> <http://example/p> \"9000\"^^<http://www.w3.org/2001/XMLSchema#byte> .");
    }

    @Test
    public void tuple_charset_1() {
        this.parseCheck("<http://example/x\\u00E9> <http://example/p> <http://example/s> .");
    }

    @Test
    public void tuple_charset_2() {
        this.parseCheck("<http://example/\u00e9> <http://example/p> \"\u00e9\" .");
    }

    protected static Tokenizer tokenizer(CharSpace charSpace, String string) {
        byte[] b = StrUtils.asUTF8bytes((String)string);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        Tokenizer tokenizer = charSpace == CharSpace.ASCII ? TokenizerFactory.makeTokenizerASCII((InputStream)in) : TokenizerFactory.makeTokenizerUTF8((InputStream)in);
        return tokenizer;
    }

    protected static Tokenizer tokenizer(String string) {
        byte[] b = StrUtils.asUTF8bytes((String)string);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8((InputStream)in);
        return tokenizer;
    }

    protected void parse(StreamRDF sink, String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        Tokenizer tokenizer = TestLangNTuples.tokenizer(string);
        LangRIOT parser = this.createParser(TestLangNTuples.tokenizer(string), sink);
        parser.getProfile().setHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
        parser.parse();
    }

    protected abstract LangRIOT createParser(Tokenizer var1, StreamRDF var2);

    protected final void parseCheck(String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        Tokenizer tokenizer = TestLangNTuples.tokenizer(string);
        StreamRDFCounting sink = StreamRDFLib.count();
        LangNQuads x = RiotReader.createParserNQuads((Tokenizer)tokenizer, (StreamRDF)sink);
        x.setProfile(RiotLib.profile(null, (boolean)false, (boolean)true, (ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx()));
        x.parse();
    }

    protected abstract long parseCount(String ... var1);
}

