/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.io.StringReader;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.lang.TestLangNTuples;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.junit.Test;

public class TestLangNTriples
extends TestLangNTuples {
    @Test
    public void nt_reader_twice() {
        String s = "_:a <p> 'foo' . ";
        StringReader r = new StringReader(s);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m, (StringReader)r, null, (Lang)RDFLanguages.NTRIPLES);
        TestLangNTriples.assertEquals((long)1L, (long)m.size());
        String x = ((Statement)m.listStatements().next()).getSubject().getId().getLabelString();
        TestLangNTriples.assertNotEquals((Object)x, (Object)"a");
        r = new StringReader(s);
        RDFDataMgr.read((Model)m, (StringReader)r, null, (Lang)RDFLanguages.NTRIPLES);
        TestLangNTriples.assertEquals((long)2L, (long)m.size());
    }

    @Test
    public void nt_model_1() {
        Model m1 = this.parseToModel("<x> <p> \"abc-\\u00E9\". ");
        TestLangNTriples.assertEquals((long)1L, (long)m1.size());
        Model m2 = this.parseToModel("<x> <p> \"abc-\\u00E9\". ");
        TestLangNTriples.assertTrue((boolean)m1.isIsomorphicWith(m2));
        Graph g1 = SSE.parseGraph((String)"(graph (triple <x> <p> \"abc-\u00e9\"))");
        TestLangNTriples.assertTrue((boolean)g1.isIsomorphicWith(m1.getGraph()));
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nt_only_1() {
        this.parseCount("<x> <p> <s> <g> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nt_only_2() {
        this.parseCount("@base <http://example/> . <x> <p> <s> .");
    }

    @Test
    public void nt_only_5() {
        this.parseCount("<x> <p> \"\u00e9\" .");
    }

    @Test(expected=RiotException.class)
    public void nt_only_5b() {
        this.parseCount(CharSpace.ASCII, "<x> <p> \"\u00e9\" .");
    }

    @Override
    protected long parseCount(String ... strings) {
        return this.parseCount(CharSpace.UTF8, strings);
    }

    private long parseCount(CharSpace charSpace, String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        Tokenizer tokenizer = TestLangNTriples.tokenizer(charSpace, string);
        StreamRDFCounting sink = StreamRDFLib.count();
        LangNTriples x = RiotReader.createParserNTriples((Tokenizer)tokenizer, (StreamRDF)sink);
        x.getProfile().setHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
        x.parse();
        return sink.count();
    }

    @Override
    protected LangRIOT createParser(Tokenizer tokenizer, StreamRDF sink) {
        return RiotReader.createParserNTriples((Tokenizer)tokenizer, (StreamRDF)sink);
    }

    protected Model parseToModel(String string) {
        StringReader r = new StringReader(string);
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (StringReader)r, null, (Lang)RDFLanguages.NTRIPLES);
        return model;
    }
}

