/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.lang.TestLangNTuples;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.junit.Test;

public class TestLangNQuads
extends TestLangNTuples {
    @Test
    public void quad_1() {
        this.parseCount("<x> <p> <s> <g> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void quad_2() {
        this.parseCount("<x> <p> <s> <g>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nq_only_1() {
        this.parseCount("<x> <p> <s> <g> <c> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nq_only_2() {
        this.parseCount("@base <http://example/> . <x> <p> <s> .");
    }

    @Test
    public void dataset_1() {
        DatasetGraph dsg = this.parseToDataset("<x> <p> <s> <g> .");
        TestLangNQuads.assertEquals((long)1L, (long)dsg.size());
        TestLangNQuads.assertEquals((long)1L, (long)dsg.getGraph(NodeFactory.createURI((String)"g")).size());
        TestLangNQuads.assertEquals((long)0L, (long)dsg.getDefaultGraph().size());
    }

    @Override
    protected long parseCount(String ... strings) {
        StreamRDFCounting sink = StreamRDFLib.count();
        this.parse((StreamRDF)sink, strings);
        return sink.count();
    }

    private DatasetGraph parseToDataset(String string) {
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        StreamRDF dest = StreamRDFLib.dataset((DatasetGraph)dsg);
        this.parse(dest, string);
        return dsg;
    }

    @Override
    protected LangRIOT createParser(Tokenizer tokenizer, StreamRDF sink) {
        return RiotReader.createParserNQuads((Tokenizer)tokenizer, (StreamRDF)sink);
    }
}

