/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.HashMap;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.junit.Assert;
import org.junit.Test;

public class TestLang
extends BaseTest {
    @Test
    public void registration_01() {
        this.testregistration(RDFLanguages.RDFXML);
    }

    @Test
    public void registration_02() {
        this.testregistration(RDFLanguages.NTRIPLES);
    }

    @Test
    public void registration_03() {
        this.testregistration(RDFLanguages.NT);
    }

    @Test
    public void registration_04() {
        this.testregistration(RDFLanguages.N3);
    }

    @Test
    public void registration_05() {
        this.testregistration(RDFLanguages.TURTLE);
    }

    @Test
    public void registration_06() {
        this.testregistration(RDFLanguages.TTL);
    }

    @Test
    public void registration_07() {
        this.testregistration(RDFLanguages.RDFJSON);
    }

    @Test
    public void registration_08() {
        this.testregistration(RDFLanguages.NQUADS);
    }

    @Test
    public void registration_09() {
        this.testregistration(RDFLanguages.NQ);
    }

    @Test
    public void registration_10() {
        this.testregistration(RDFLanguages.TRIG);
    }

    @Test
    public void registration_11() {
        this.testregistration(RDFLanguages.RDFNULL);
    }

    @Test
    public void registration_01a() {
        this.testregistration(Lang.RDFXML);
    }

    @Test
    public void registration_02a() {
        this.testregistration(Lang.NTRIPLES);
    }

    @Test
    public void registration_03a() {
        this.testregistration(Lang.NT);
    }

    @Test
    public void registration_04a() {
        this.testregistration(Lang.N3);
    }

    @Test
    public void registration_05a() {
        this.testregistration(Lang.TURTLE);
    }

    @Test
    public void registration_06a() {
        this.testregistration(Lang.TTL);
    }

    @Test
    public void registration_07a() {
        this.testregistration(Lang.RDFJSON);
    }

    @Test
    public void registration_08a() {
        this.testregistration(Lang.NQUADS);
    }

    @Test
    public void registration_09a() {
        this.testregistration(Lang.NQ);
    }

    @Test
    public void registration_10a() {
        this.testregistration(Lang.TRIG);
    }

    @Test
    public void registration_11a() {
        this.testregistration(Lang.RDFNULL);
    }

    private void testregistration(Lang lang) {
        TestLang.assertTrue((String)("No registration for " + lang), (boolean)RDFLanguages.getRegisteredLanguages().contains(lang));
    }

    @Test
    public void lang_01() {
        TestLang.assertEquals((Object)RDFLanguages.TURTLE, (Object)RDFLanguages.shortnameToLang((String)"TTL"));
    }

    @Test
    public void lang_02() {
        TestLang.assertEquals((Object)RDFLanguages.TURTLE, (Object)RDFLanguages.shortnameToLang((String)"ttl"));
    }

    @Test
    public void lang_03() {
        TestLang.assertEquals((Object)RDFLanguages.TURTLE, (Object)RDFLanguages.shortnameToLang((String)"Turtle"));
    }

    @Test
    public void lang_04() {
        TestLang.assertEquals((Object)RDFLanguages.RDFXML, (Object)RDFLanguages.shortnameToLang((String)"RDF/XML"));
    }

    @Test
    public void lang_05() {
        TestLang.assertEquals((Object)RDFLanguages.RDFXML, (Object)RDFLanguages.shortnameToLang((String)"RDF/XML-ABBREV"));
    }

    @Test
    public void lang_06() {
        TestLang.assertEquals((Object)RDFLanguages.NTRIPLES, (Object)RDFLanguages.shortnameToLang((String)"N-TRIPLE"));
    }

    @Test
    public void lang_07() {
        TestLang.assertEquals((Object)RDFLanguages.NTRIPLES, (Object)RDFLanguages.shortnameToLang((String)"N-TRIPLES"));
    }

    @Test
    public void lang_08() {
        TestLang.assertEquals((Object)RDFLanguages.NQUADS, (Object)RDFLanguages.shortnameToLang((String)"NQUADS"));
    }

    @Test
    public void lang_09() {
        TestLang.assertEquals((Object)RDFLanguages.TRIG, (Object)RDFLanguages.shortnameToLang((String)"TRIG"));
    }

    @Test
    public void lang_10() {
        TestLang.assertEquals((Object)RDFLanguages.RDFJSON, (Object)RDFLanguages.shortnameToLang((String)"RDF/JSON"));
    }

    @Test
    public void lang_11() {
        TestLang.assertEquals((Object)RDFLanguages.RDFJSON, (Object)RDFLanguages.shortnameToLang((String)"RDF/JSON"));
    }

    @Test
    public void testFileExtensionsProvided() {
        for (Lang l : RDFLanguages.getRegisteredLanguages()) {
            if (RDFLanguages.RDFNULL.equals((Object)l)) continue;
            Assert.assertNotNull((String)(l + " does not have file extensions defined"), (Object)l.getFileExtensions());
            Assert.assertTrue((String)(l + " does not have file extensions defined"), (l.getFileExtensions().size() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileExtensionUnique() {
        HashMap<String, Lang> exts = new HashMap<String, Lang>();
        for (Lang lang1 : RDFLanguages.getRegisteredLanguages()) {
            for (String ext : lang1.getFileExtensions()) {
                Lang lang2 = (Lang)exts.get(ext);
                Assert.assertTrue((String)("The " + ext + " file extensions in " + lang1 + " was already used"), (lang2 == null || lang1 == lang2 ? 1 : 0) != 0);
                exts.put(ext, lang1);
            }
        }
    }

    @Test
    public void testDefaultInExtensions() {
        for (Lang l : RDFLanguages.getRegisteredLanguages()) {
            if (RDFLanguages.RDFNULL.equals((Object)l)) continue;
            Assert.assertTrue((String)(l + " default extension not in file extensions list"), (boolean)l.getFileExtensions().contains(l.getFileExtensions().get(0)));
        }
    }

    @Test
    public void testGet() {
        for (Lang l : RDFLanguages.getRegisteredLanguages()) {
            Assert.assertNotNull((String)(l + " can not be parsed by name"), (Object)RDFLanguages.shortnameToLang((String)l.getName()));
        }
    }
}

