/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.checker.CheckerIRI;
import org.apache.jena.riot.system.Checker;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.IRILib;
import org.apache.jena.riot.system.RiotLib;
import org.junit.Test;

public class TestIRI
extends BaseTest {
    protected static final ErrorHandler handler = new ErrorHandlerTestLib.ErrorHandlerEx();
    protected static final Checker checker = new Checker((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
    static IRIFactory factory = IRIFactory.iriImplementation();

    @Test
    public void iri1() {
        this.testIRI("http://example/");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void iri2() {
        this.testIRI("example");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void iriErr1() {
        this.testIRI("http:");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void iriErr2() {
        this.testIRI("http:///::");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void iriErr3() {
        this.testIRI("http://example/.");
    }

    private void testIRI(String uriStr) {
        IRI iri = factory.create(uriStr);
        CheckerIRI.iriViolations((IRI)iri, (ErrorHandler)handler);
    }

    @Test
    public void bNodeIRI_1() {
        Node n = RiotLib.createIRIorBNode((String)"_:abc");
        TestIRI.assertTrue((boolean)n.isBlank());
        TestIRI.assertEquals((Object)"abc", (Object)n.getBlankNodeLabel());
    }

    @Test
    public void bNodeIRI_2() {
        Node n = RiotLib.createIRIorBNode((String)"abc");
        TestIRI.assertTrue((boolean)n.isURI());
        TestIRI.assertEquals((Object)"abc", (Object)n.getURI());
    }

    @Test
    public void fileIRI_1() {
        String uri = TestIRI.testFileIRI("D.ttl");
        TestIRI.assertTrue((boolean)uri.endsWith("D.ttl"));
    }

    @Test
    public void fileIRI_2() {
        String uri = TestIRI.testFileIRI("file:/D.ttl");
        TestIRI.assertTrue((boolean)uri.endsWith("D.ttl"));
    }

    @Test
    public void fileIRI_3() {
        String uri = TestIRI.testFileIRI("file://D.ttl");
        TestIRI.assertTrue((boolean)uri.endsWith("D.ttl"));
    }

    @Test
    public void fileIRI_4() {
        String iri = TestIRI.testFileIRI("file:///D.ttl");
        TestIRI.assertEquals((Object)"file:///D.ttl", (Object)iri);
    }

    private static String testFileIRI(String fn) {
        String uri1 = IRILib.filenameToIRI((String)fn);
        TestIRI.assertTrue((boolean)uri1.startsWith("file:///"));
        String uri2 = IRILib.filenameToIRI((String)uri1);
        TestIRI.assertEquals((Object)uri1, (Object)uri2);
        return uri1;
    }
}

