/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.common;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import com.hp.hpl.jena.sparql.util.IsoMatcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.Tuple;
import org.junit.Test;

public class TestIsoMatcher
extends BaseTest {
    private static Node[] T = new Node[0];

    @Test
    public void iso_00() {
        this.testGraph("", "", true);
    }

    @Test
    public void iso_01() {
        this.testGraph("(<x> <p> 1)", "(<x> <p> 1)", true);
    }

    @Test
    public void iso_02() {
        this.testGraph("(<x> <p> 1)", "(<x> <p> 2)", false);
    }

    @Test
    public void iso_03() {
        this.testGraph("(<x> <p> 1) (<x> <p> 2)", "(<x> <p> 2)", false);
    }

    @Test
    public void iso_04() {
        this.testGraph("(<x> <p> _:a)", "(<x> <p> 2)", false);
    }

    @Test
    public void iso_05() {
        this.testGraph("(<x> <p> _:a)", "(<x> <p> _:b)", true);
    }

    @Test
    public void iso_06() {
        this.testGraph("(_:a <p> _:a)", "(_:b <p> _:b)", true);
    }

    @Test
    public void iso_07() {
        this.testGraph("(_:a1 <p> _:a2)", "(_:bb <p> _:bb)", false);
    }

    @Test
    public void iso_10() {
        this.testGraph("(_:a _:a _:a)", "(_:b _:b _:b)", true);
    }

    @Test
    public void iso_11() {
        this.testGraph("(_:a _:a _:a)", "(_:z _:b _:b)", false);
    }

    @Test
    public void iso_12() {
        this.testGraph("(_:a _:a _:a)", "(_:b _:z _:b)", false);
    }

    @Test
    public void iso_13() {
        this.testGraph("(_:a _:a _:a)", "(_:b _:b _:z)", false);
    }

    @Test
    public void iso_14() {
        this.testGraph("(_:a _:a _:b)", "(_:b _:b _:z)", true);
    }

    @Test
    public void iso_15() {
        this.testGraph("(_:a _:x _:a)", "(_:b _:z _:b)", true);
    }

    @Test
    public void iso_16() {
        this.testGraph("(_:x _:a _:a)", "(_:z _:b _:b)", true);
    }

    @Test
    public void iso_20() {
        this.testGraph("(<x> <p> _:a) (<z> <p> _:a)", "(<x> <p> _:b) (<z> <p> _:b)", true);
    }

    @Test
    public void iso_21() {
        this.testGraph("(<x> <p> _:a1) (<z> <p> _:a2)", "(<x> <p> _:b) (<z> <p> _:b)", false);
    }

    @Test
    public void iso_22() {
        this.testGraph("(_:a <p> _:a) (<s> <q> _:a)", "(_:b <p> _:b) (<s> <q> _:b)", true);
    }

    @Test
    public void iso_23() {
        this.testGraph("(_:a <p> _:a) (<s> <q> _:a)", "(_:b <p> _:b) (<s> <q> _:c)", false);
    }

    @Test
    public void iso_24() {
        this.testGraph("(_:a <p> _:a) (<s> <q> _:a) (_:b <q> _:b)", "(_:b <p> _:b) (<s> <q> _:b) (_:b <q> _:b)", false);
    }

    @Test
    public void iso_50() {
        this.testDSG("(graph (_:a <p> _:a)) (graph <g> (<s> <q> _:a))", "(graph (_:a <p> _:a)) (graph <g> (<s> <q> _:a))", true);
    }

    @Test
    public void iso_51() {
        this.testDSG("(graph (_:a <p> _:a)) (graph <g> (<s> <q> _:a))", "(graph (_:a <p> _:a)) (graph <g> (<s> <q> _:b))", false);
    }

    @Test
    public void iso_61() {
        String[] x1 = new String[]{};
        String[] x2 = new String[]{};
        this.test(x1, x2, true);
    }

    @Test
    public void iso_62() {
        String[] x1 = new String[]{"(<x> <p> 1)"};
        String[] x2 = new String[]{};
        this.test(x1, x2, false);
    }

    @Test
    public void iso_63() {
        String[] x1 = new String[]{"(_:x <p> 1)"};
        String[] x2 = new String[]{"(_:y <p> 1)"};
        this.test(x1, x2, true);
    }

    @Test
    public void iso_64() {
        String[] x1 = new String[]{"(_:x <p> 1)", "(_:x <p> 1)"};
        String[] x2 = new String[]{"(_:y <p> 1)", "(_:x <p> 1)"};
        this.test(x1, x2, true);
    }

    @Test
    public void iso_65() {
        String[] x1 = new String[]{"(_:x <p> 1)", "(_:y <p> 1)"};
        String[] x2 = new String[]{"(_:y <p> 1)", "(_:x <p> 1)"};
        this.test(x1, x2, true);
    }

    @Test
    public void iso_66() {
        String[] x1 = new String[]{"(_:a <p> 1)", "(_:b <p> 1)", "(_:a <p> 2)"};
        String[] x2 = new String[]{"(_:y <p> 1)", "(_:z <p> 1)", "(_:z <p> 2)"};
        this.test(x1, x2, true);
    }

    private void test(String[] x1, String[] x2, boolean iso) {
        List<Tuple<Node>> t1 = this.tuples(x1);
        List<Tuple<Node>> t2 = this.tuples(x2);
        this.test$(t1, t2, iso);
    }

    private void test$(List<Tuple<Node>> t1, List<Tuple<Node>> t2, boolean iso) {
        boolean b = IsoMatcher.isomorphic(t1, t2);
        if (b != iso) {
            System.out.println("====");
            System.out.println(t1);
            System.out.println("----");
            System.out.println(t2);
            System.out.println("Expected: " + iso + " ; got: " + b);
        }
        TestIsoMatcher.assertEquals((Object)iso, (Object)b);
    }

    private List<Tuple<Node>> tuples(String[] strings) {
        ArrayList<Tuple<Node>> tuples = new ArrayList<Tuple<Node>>();
        for (String s : strings) {
            Item item = SSE.parse((String)s);
            List list = BuilderNode.buildNodeList((Item)item);
            Tuple tuple = Tuple.create((Object[])list.toArray(T));
            tuples.add((Tuple<Node>)tuple);
        }
        return tuples;
    }

    private void testGraph(String s1, String s2, boolean iso) {
        this.testGraph$(s1, s2, iso);
        this.testGraph$(s2, s1, iso);
    }

    private void testGraph$(String s1, String s2, boolean iso) {
        Graph g2;
        s1 = "(graph " + s1 + ")";
        s2 = "(graph " + s2 + ")";
        Graph g1 = SSE.parseGraph((String)s1);
        boolean b = IsoMatcher.isomorphic((Graph)g1, (Graph)(g2 = SSE.parseGraph((String)s2)));
        if (b != iso) {
            System.out.println("====");
            SSE.write((Graph)g1);
            System.out.println("----");
            SSE.write((Graph)g2);
            System.out.println("Expected: " + iso + " ; got: " + b);
        }
        TestIsoMatcher.assertEquals((Object)iso, (Object)b);
        TestIsoMatcher.assertEquals((Object)b, (Object)g1.isIsomorphicWith(g2));
    }

    private void testDSG(String s1, String s2, boolean iso) {
        this.testDSG$(s1, s2, iso);
        this.testDSG$(s2, s1, iso);
    }

    private void testQuads(String s1, String s2, boolean iso) {
    }

    private void testDSG$(String s1, String s2, boolean iso) {
        DatasetGraph dsg2;
        s1 = "(dataset " + s1 + ")";
        s2 = "(dataset " + s2 + ")";
        DatasetGraph dsg1 = SSE.parseDatasetGraph((String)s1);
        boolean b = IsoMatcher.isomorphic((DatasetGraph)dsg1, (DatasetGraph)(dsg2 = SSE.parseDatasetGraph((String)s2)));
        if (b != iso) {
            System.out.println("====");
            SSE.write((DatasetGraph)dsg1);
            System.out.println("----");
            SSE.write((DatasetGraph)dsg2);
            System.out.println("Expected: " + iso + " ; got: " + b);
        }
        TestIsoMatcher.assertEquals((Object)iso, (Object)b);
    }
}

