/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.List;
import org.apache.jena.atlas.lib.Trie;
import org.junit.Assert;
import org.junit.Test;

public class TestTrie {
    @Test
    public void trie_add_01() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        Assert.assertTrue((boolean)trie.contains("test"));
        Assert.assertEquals((Object)123, (Object)trie.get("test"));
    }

    @Test
    public void trie_add_02() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("other", (Object)456);
        Assert.assertTrue((boolean)trie.contains("test"));
        Assert.assertTrue((boolean)trie.contains("other"));
        Assert.assertEquals((Object)123, (Object)trie.get("test"));
        Assert.assertEquals((Object)456, (Object)trie.get("other"));
    }

    @Test
    public void trie_add_03() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("test", (Object)456);
        Assert.assertTrue((boolean)trie.contains("test"));
        Assert.assertEquals((Object)456, (Object)trie.get("test"));
    }

    @Test
    public void trie_add_04() {
        Trie trie = new Trie();
        trie.add("test", null);
        Assert.assertFalse((boolean)trie.contains("test"));
    }

    @Test
    public void trie_add_05() {
        Trie trie = new Trie();
        trie.add(null, (Object)123);
        Assert.assertTrue((boolean)trie.contains(null));
        Assert.assertEquals((Object)123, (Object)trie.get(null));
    }

    @Test
    public void trie_add_06() {
        Trie trie = new Trie();
        trie.add("", (Object)123);
        Assert.assertTrue((boolean)trie.contains(""));
        Assert.assertEquals((Object)123, (Object)trie.get(""));
    }

    @Test
    public void trie_contains_01() {
        Trie trie = new Trie();
        Assert.assertFalse((boolean)trie.contains("test"));
    }

    @Test
    public void trie_contains_02() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        Assert.assertTrue((boolean)trie.contains("test"));
        Assert.assertTrue((boolean)trie.contains("test", true));
        Assert.assertTrue((boolean)trie.contains("test", (Object)123));
        Assert.assertFalse((boolean)trie.contains("t"));
        Assert.assertTrue((boolean)trie.contains("t", false));
    }

    @Test
    public void trie_contains_03() {
        Trie trie = new Trie();
        Assert.assertFalse((boolean)trie.contains(null));
        Assert.assertTrue((boolean)trie.contains(null, false));
    }

    @Test
    public void trie_contains_04() {
        Trie trie = new Trie();
        Assert.assertFalse((boolean)trie.contains(""));
        Assert.assertTrue((boolean)trie.contains("", false));
    }

    @Test
    public void trie_remove_01() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        Assert.assertTrue((boolean)trie.contains("test"));
        Assert.assertEquals((Object)123, (Object)trie.get("test"));
        trie.remove("test");
        Assert.assertFalse((boolean)trie.contains("test"));
        Assert.assertTrue((boolean)trie.contains("test", false));
        Assert.assertNull((Object)trie.get("test"));
    }

    @Test
    public void trie_remove_02() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        Assert.assertTrue((boolean)trie.contains("test"));
        Assert.assertEquals((Object)123, (Object)trie.get("test"));
        Assert.assertTrue((boolean)trie.contains("testing"));
        Assert.assertEquals((Object)456, (Object)trie.get("testing"));
        trie.remove("test");
        Assert.assertFalse((boolean)trie.contains("test"));
        Assert.assertTrue((boolean)trie.contains("test", false));
        Assert.assertNull((Object)trie.get("test"));
        Assert.assertTrue((boolean)trie.contains("testing"));
        Assert.assertEquals((Object)456, (Object)trie.get("testing"));
    }

    @Test
    public void trie_remove_03() {
        Trie trie = new Trie();
        trie.add(null, (Object)123);
        Assert.assertTrue((boolean)trie.contains(null));
        Assert.assertEquals((Object)123, (Object)trie.get(null));
        trie.remove(null);
        Assert.assertFalse((boolean)trie.contains(null));
    }

    @Test
    public void trie_remove_04() {
        Trie trie = new Trie();
        trie.add("", (Object)123);
        Assert.assertTrue((boolean)trie.contains(""));
        Assert.assertEquals((Object)123, (Object)trie.get(""));
        trie.remove("");
        Assert.assertFalse((boolean)trie.contains(""));
    }

    @Test
    public void trie_prefix_search_01() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        List matches = trie.prefixSearch("test");
        Assert.assertEquals((long)2L, (long)matches.size());
        matches = trie.prefixSearch("testi");
        Assert.assertEquals((long)1L, (long)matches.size());
        matches = trie.prefixSearch("testingly");
        Assert.assertEquals((long)0L, (long)matches.size());
        matches = trie.prefixSearch(null);
        Assert.assertEquals((long)2L, (long)matches.size());
    }

    @Test
    public void trie_partial_search_01() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        List matches = trie.partialSearch("test");
        Assert.assertEquals((long)1L, (long)matches.size());
        matches = trie.partialSearch("testi");
        Assert.assertEquals((long)1L, (long)matches.size());
        matches = trie.partialSearch("testingly");
        Assert.assertEquals((long)2L, (long)matches.size());
        matches = trie.partialSearch(null);
        Assert.assertEquals((long)0L, (long)matches.size());
    }

    @Test
    public void trie_longest_match_01() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        Assert.assertTrue((boolean)trie.contains("test"));
        Assert.assertTrue((boolean)trie.contains("testing"));
        Assert.assertEquals((Object)456, (Object)trie.longestMatch("testing"));
    }

    @Test
    public void trie_longest_match_02() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        Assert.assertEquals((Object)456, (Object)trie.longestMatch("testingly"));
    }

    @Test
    public void trie_longest_match_03() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        trie.remove("testing");
        Assert.assertEquals((Object)123, (Object)trie.longestMatch("testing"));
    }

    @Test
    public void trie_shortest_match_01() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        Assert.assertTrue((boolean)trie.contains("test"));
        Assert.assertTrue((boolean)trie.contains("testing"));
        Assert.assertEquals((Object)123, (Object)trie.shortestMatch("testing"));
    }

    @Test
    public void trie_shortest_match_02() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        Assert.assertEquals((Object)123, (Object)trie.shortestMatch("testingly"));
    }

    @Test
    public void trie_shortest_match_03() {
        Trie trie = new Trie();
        trie.add("test", (Object)123);
        trie.add("testing", (Object)456);
        trie.remove("test");
        Assert.assertEquals((Object)456, (Object)trie.shortestMatch("testing"));
    }
}

