/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.MultiSet;
import org.junit.Test;

public class TestMultiSet
extends BaseTest {
    @Test
    public void multiSet_01() {
        MultiSet x = new MultiSet();
        TestMultiSet.assertTrue((boolean)x.isEmpty());
        TestMultiSet.assertEquals((long)0L, (long)x.count((Object)"A"));
    }

    @Test
    public void multiSet_02() {
        MultiSet x = new MultiSet();
        x.add((Object)"A");
        TestMultiSet.assertFalse((boolean)x.isEmpty());
        TestMultiSet.assertEquals((long)1L, (long)x.count((Object)"A"));
        x.add((Object)"A");
        TestMultiSet.assertEquals((long)2L, (long)x.count((Object)"A"));
    }

    @Test
    public void multiSet_03() {
        MultiSet x = new MultiSet();
        x.add((Object)"A");
        x.add((Object)"A");
        x.remove((Object)"A");
        TestMultiSet.assertEquals((long)1L, (long)x.count((Object)"A"));
        TestMultiSet.assertTrue((boolean)x.contains((Object)"A"));
        x.remove((Object)"A");
        TestMultiSet.assertEquals((long)0L, (long)x.count((Object)"A"));
        TestMultiSet.assertFalse((boolean)x.contains((Object)"A"));
    }

    @Test
    public void multiSet_04() {
        String[] data = new String[]{};
        TestMultiSet.iterTest(data);
    }

    @Test
    public void multiSet_05() {
        String[] data = new String[]{"A"};
        TestMultiSet.iterTest(data);
    }

    @Test
    public void multiSet_06() {
        String[] data = new String[]{"A", "B", "C"};
        TestMultiSet.iterTest(data);
    }

    @Test
    public void multiSet_07() {
        String[] data = new String[]{"A", "B", "C", "A"};
        TestMultiSet.iterTest(data);
    }

    @Test
    public void multiSet_08() {
        String[] data = new String[]{};
        MultiSet<String> x = TestMultiSet.add(data);
        TestMultiSet.assertEquals((long)0L, (long)x.size());
    }

    @Test
    public void multiSet_09() {
        String[] data = new String[]{"A", "A"};
        MultiSet<String> x = TestMultiSet.add(data);
        TestMultiSet.assertEquals((long)2L, (long)x.size());
    }

    @Test
    public void multiSet_10() {
        String[] data = new String[]{"A", "A"};
        MultiSet<String> x = TestMultiSet.add(data);
        x.remove((Object)"A");
        TestMultiSet.assertEquals((long)1L, (long)x.size());
        x.remove((Object)"A");
        TestMultiSet.assertEquals((long)0L, (long)x.size());
        x.remove((Object)"A");
        TestMultiSet.assertEquals((long)0L, (long)x.size());
    }

    @Test
    public void multiSet_11() {
        String[] data = new String[]{"A", "A"};
        MultiSet<String> x = TestMultiSet.add(data);
        long c = Iter.count((Iterator)x.elements());
        TestMultiSet.assertEquals((long)1L, (long)c);
    }

    private static MultiSet<String> add(String[] data) {
        MultiSet x = new MultiSet();
        for (String str : data) {
            x.add((Object)str);
        }
        return x;
    }

    private static void iterTest(String[] data) {
        List<String> expected = Arrays.asList(data);
        MultiSet x = new MultiSet();
        for (String str : data) {
            x.add((Object)str);
        }
        List actual = Iter.toList((Iterator)x.iterator());
        Collections.sort(expected);
        Collections.sort(actual);
        TestMultiSet.assertEquals(expected, (Object)actual);
    }
}

