/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.iterator.IteratorWithBuffer;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestIteratorWithBuffer
extends BaseTest {
    @Test
    public void iterBuffer_01() {
        IteratorWithBuffer<String> iter = this.createBuffered(1, "a", "b", "c");
        TestIteratorWithBuffer.assertEquals((long)1L, (long)iter.currentSize());
        TestIteratorWithBuffer.assertEquals((Object)"a", (Object)iter.peek(0));
        TestIteratorWithBuffer.assertEquals((long)1L, (long)iter.currentSize());
        TestIteratorWithBuffer.assertEquals((Object)"a", (Object)iter.next());
        TestIteratorWithBuffer.assertEquals((long)1L, (long)iter.currentSize());
        TestIteratorWithBuffer.assertEquals((Object)"b", (Object)iter.peek(0));
        TestIteratorWithBuffer.assertEquals((long)1L, (long)iter.currentSize());
        TestIteratorWithBuffer.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorWithBuffer.assertEquals((long)1L, (long)iter.currentSize());
        TestIteratorWithBuffer.assertEquals((Object)"c", (Object)iter.peek(0));
        TestIteratorWithBuffer.assertEquals((long)1L, (long)iter.currentSize());
        TestIteratorWithBuffer.assertEquals((Object)"c", (Object)iter.next());
        TestIteratorWithBuffer.assertEquals((long)0L, (long)iter.currentSize());
        TestIteratorWithBuffer.assertEquals(null, (Object)iter.peek(0));
        TestIteratorWithBuffer.assertEquals((long)0L, (long)iter.currentSize());
    }

    @Test
    public void iterBuffer_02() {
        IteratorWithBuffer<String> iter = this.createBuffered(2, "a", "b", "c");
        TestIteratorWithBuffer.assertEquals((long)2L, (long)iter.currentSize());
        TestIteratorWithBuffer.assertEquals((Object)"a", (Object)iter.peek(0));
        TestIteratorWithBuffer.assertEquals((Object)"b", (Object)iter.peek(1));
        TestIteratorWithBuffer.assertEquals((Object)"a", (Object)iter.next());
        TestIteratorWithBuffer.assertEquals((Object)"b", (Object)iter.peek(0));
        TestIteratorWithBuffer.assertEquals((Object)"c", (Object)iter.peek(1));
        TestIteratorWithBuffer.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorWithBuffer.assertEquals((Object)"c", (Object)iter.peek(0));
        TestIteratorWithBuffer.assertEquals(null, (Object)iter.peek(1));
        TestIteratorWithBuffer.assertEquals((Object)"c", (Object)iter.next());
        TestIteratorWithBuffer.assertEquals(null, (Object)iter.peek(0));
    }

    @Test
    public void iterBuffer_03() {
        IteratorWithBuffer<String> iter = this.createBuffered(1, new String[0]);
        TestIteratorWithBuffer.assertEquals(null, (Object)iter.peek(0));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void iterBuffer_04() {
        IteratorWithBuffer<String> iter = this.createBuffered(0, "a");
        TestIteratorWithBuffer.assertEquals(null, (Object)iter.peek(0));
    }

    @Test
    public void iterBuffer_05() {
        IteratorWithBuffer<String> iter = this.createBuffered(2, "a");
        TestIteratorWithBuffer.assertEquals((Object)"a", (Object)iter.peek(0));
        TestIteratorWithBuffer.assertEquals(null, (Object)iter.peek(1));
        TestIteratorWithBuffer.assertEquals((Object)"a", (Object)iter.next());
    }

    private IteratorWithBuffer<String> createBuffered(int N, String ... strings) {
        List<String> data = Arrays.asList(strings);
        IteratorWithBuffer iter = new IteratorWithBuffer(data.iterator(), N);
        return iter;
    }
}

