/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorArray;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestIteratorPeek
extends BaseTest {
    List<String> data0 = new ArrayList<String>();
    List<String> data1 = new ArrayList<String>();
    List<String> data2;

    public TestIteratorPeek() {
        this.data1.add("a");
        this.data2 = new ArrayList<String>();
        this.data2.add("x");
        this.data2.add("y");
        this.data2.add("z");
    }

    @Test
    public void iter_01() {
        Iter iter = Iter.iter(this.data2);
        iter = iter.append(this.data2.iterator());
        this.test(iter, "x", "y", "z", "x", "y", "z");
    }

    private void test(Iter<?> iter, Object ... items) {
        for (Object x : items) {
            TestIteratorPeek.assertTrue((boolean)iter.hasNext());
            TestIteratorPeek.assertEquals((Object)x, (Object)iter.next());
        }
        TestIteratorPeek.assertFalse((boolean)iter.hasNext());
    }

    private static PeekIterator<String> create(String ... a) {
        return new PeekIterator((Iterator)IteratorArray.create((Object[])a));
    }

    @Test
    public void peek_1() {
        PeekIterator<String> peek = TestIteratorPeek.create("a", "b", "c");
        TestIteratorPeek.assertEquals((Object)"a", (Object)peek.peek());
        this.test(Iter.iter(peek), "a", "b", "c");
    }

    @Test
    public void peek_2() {
        PeekIterator<String> peek = TestIteratorPeek.create(new String[0]);
        TestIteratorPeek.assertFalse((boolean)peek.hasNext());
    }

    @Test
    public void peek_3() {
        PeekIterator<String> peek = TestIteratorPeek.create("a");
        TestIteratorPeek.assertEquals((Object)"a", (Object)peek.peek());
    }

    @Test
    public void peek_4() {
        PeekIterator<String> peek = TestIteratorPeek.create("a");
        TestIteratorPeek.assertEquals((Object)"a", (Object)peek.peek());
        TestIteratorPeek.assertEquals((Object)"a", (Object)peek.peek());
        TestIteratorPeek.assertEquals((Object)"a", (Object)peek.next());
        TestIteratorPeek.assertFalse((boolean)peek.hasNext());
    }

    @Test
    public void peek_5() {
        PeekIterator<String> peek = TestIteratorPeek.create("a", "b");
        TestIteratorPeek.assertEquals((Object)"a", (Object)peek.peek());
        TestIteratorPeek.assertEquals((Object)"a", (Object)peek.peek());
        TestIteratorPeek.assertEquals((Object)"a", (Object)peek.next());
        TestIteratorPeek.assertTrue((boolean)peek.hasNext());
        TestIteratorPeek.assertEquals((Object)"b", (Object)peek.peek());
        TestIteratorPeek.assertEquals((Object)"b", (Object)peek.peek());
        TestIteratorPeek.assertEquals((Object)"b", (Object)peek.next());
        TestIteratorPeek.assertFalse((boolean)peek.hasNext());
    }
}

