/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Filter;
import org.apache.jena.atlas.iterator.FilterStack;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;
import org.junit.Assert;
import org.junit.Test;

public class TestIter {
    List<String> data0 = new ArrayList<String>();
    List<String> data1 = Arrays.asList("a");
    List<String> data2 = Arrays.asList("x", "y", "z");
    List<String> data3 = Arrays.asList(null, "x", null, null, null, "y", "z", null);
    static Iter.Folder<String, String> f1 = new Iter.Folder<String, String>(){

        public String eval(String acc, String arg) {
            return acc + arg;
        }
    };
    Filter<String> filter = new Filter<String>(){

        public boolean accept(String item) {
            return item.length() == 1;
        }
    };

    @Test
    public void append_1() {
        Iterator iter = Iter.append(this.data1, this.data0);
        this.test(iter, "a");
    }

    @Test
    public void append_2() {
        Iterator iter = Iter.append(this.data0, this.data1);
        this.test(iter, "a");
    }

    @Test
    public void append_3() {
        Iterator iter = Iter.append(this.data1, this.data2);
        this.test(iter, "a", "x", "y", "z");
    }

    @Test
    public void append_4() {
        ArrayList<String> L = new ArrayList<String>(3);
        L.add("a");
        L.add("b");
        L.add("c");
        ArrayList<String> R = new ArrayList<String>(3);
        R.add("d");
        R.add("e");
        R.add("f");
        Iterator LR = Iter.append(L, R);
        while (LR.hasNext()) {
            String s = (String)LR.next();
            if (!"c".equals(s)) continue;
            LR.hasNext();
            LR.remove();
        }
        Assert.assertEquals((Object)"ab", (Object)Iter.asString(L, (String)""));
        Assert.assertEquals((Object)"def", (Object)Iter.asString(R, (String)""));
    }

    @Test
    public void append_5() {
        ArrayList<String> L = new ArrayList<String>(3);
        L.add("a");
        L.add("b");
        L.add("c");
        ArrayList<String> R = new ArrayList<String>(3);
        R.add("d");
        R.add("e");
        R.add("f");
        Iterator LR = Iter.append(L, R);
        while (LR.hasNext()) {
            String s = (String)LR.next();
            if (!"d".equals(s)) continue;
            LR.hasNext();
            LR.remove();
        }
        Assert.assertEquals((Object)"abc", (Object)Iter.asString(L, (String)""));
        Assert.assertEquals((Object)"ef", (Object)Iter.asString(R, (String)""));
    }

    @Test
    public void append_6() {
        ArrayList<String> L = new ArrayList<String>(3);
        L.add("a");
        L.add("b");
        L.add("c");
        ArrayList<String> R = new ArrayList<String>(3);
        R.add("d");
        R.add("e");
        R.add("f");
        Iterator LR = Iter.append(L, R);
        while (LR.hasNext()) {
            LR.next();
        }
        LR.remove();
        Assert.assertEquals((Object)"abc", (Object)Iter.asString(L, (String)""));
        Assert.assertEquals((Object)"de", (Object)Iter.asString(R, (String)""));
    }

    @Test
    public void asString_1() {
        String x = Iter.asString(this.data0, (String)"");
        Assert.assertEquals((Object)"", (Object)x);
    }

    @Test
    public void asString_2() {
        String x = Iter.asString(this.data1, (String)"");
        Assert.assertEquals((Object)"a", (Object)x);
    }

    @Test
    public void asString_3() {
        String x = Iter.asString(this.data1, (String)"/");
        Assert.assertEquals((Object)"a", (Object)x);
    }

    @Test
    public void asString_4() {
        String x = Iter.asString(this.data2, (String)"/");
        Assert.assertEquals((Object)"x/y/z", (Object)x);
    }

    private void test(Iterator<?> iter, Object ... items) {
        for (Object x : items) {
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)x, iter.next());
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void fold_01() {
        String[] x = new String[]{"a", "b", "c"};
        String z = (String)Iter.foldLeft(Arrays.asList(x), f1, (Object)"X");
        Assert.assertEquals((Object)"Xabc", (Object)z);
    }

    @Test
    public void fold_02() {
        String[] x = new String[]{"a", "b", "c"};
        String z = (String)Iter.foldRight(Arrays.asList(x), f1, (Object)"X");
        Assert.assertEquals((Object)"Xcba", (Object)z);
    }

    @Test
    public void fold_03() {
        String[] x = new String[]{};
        String z = (String)Iter.foldLeft(Arrays.asList(x), f1, (Object)"X");
        Assert.assertEquals((Object)"X", (Object)z);
    }

    @Test
    public void fold_04() {
        String[] x = new String[]{};
        String z = (String)Iter.foldRight(Arrays.asList(x), f1, (Object)"X");
        Assert.assertEquals((Object)"X", (Object)z);
    }

    @Test
    public void map_01() {
        Iterator it = Iter.map(this.data2.iterator(), (Transform)new Transform<String, String>(){

            public String convert(String item) {
                return item + item;
            }
        });
        this.test(it, "xx", "yy", "zz");
    }

    @Test
    public void mapMany_01() {
        Iterator it = Iter.mapMany(this.data2.iterator(), (Transform)new Transform<String, Iterator<String>>(){

            public Iterator<String> convert(String item) {
                ArrayList<String> l = new ArrayList<String>(2);
                l.add(item);
                l.add(item + item);
                return l.iterator();
            }
        });
        this.test(it, "x", "xx", "y", "yy", "z", "zz");
    }

    @Test
    public void mapMany_02() {
        Iterator it = Iter.mapMany(this.data2.iterator(), (Transform)new Transform<String, Iterator<String>>(){

            public Iterator<String> convert(String item) {
                return Iter.nullIterator();
            }
        });
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void mapMany_03() {
        Iterator it = Iter.mapMany(this.data2.iterator(), (Transform)new Transform<String, Iterator<String>>(){
            int count = 0;

            public Iterator<String> convert(String item) {
                ++this.count;
                if (this.count % 2 == 1) {
                    return Iter.singleton((Object)item);
                }
                return Iter.nullIterator();
            }
        });
        this.test(it, "x", "z");
    }

    @Test
    public void mapMany_04() {
        Iterator it = Iter.mapMany(this.data2.iterator(), (Transform)new Transform<String, Iterator<String>>(){
            int count = 0;

            public Iterator<String> convert(String item) {
                ++this.count;
                if (this.count % 2 == 0) {
                    return Iter.singleton((Object)item);
                }
                return Iter.nullIterator();
            }
        });
        this.test(it, "y");
    }

    @Test
    public void first_01() {
        Iter iter = Iter.nullIter();
        Assert.assertEquals(null, (Object)Iter.first((Iterator)iter, this.filter));
    }

    @Test
    public void first_02() {
        List<String> data = Arrays.asList("11", "A", "B", "C");
        Assert.assertEquals((Object)"A", (Object)Iter.first(data, this.filter));
    }

    @Test
    public void first_03() {
        List<String> data = Arrays.asList("11", "AA", "BB", "CC");
        Assert.assertEquals(null, (Object)Iter.first(data, this.filter));
    }

    @Test
    public void first_04() {
        Iter iter = Iter.nullIter();
        Assert.assertEquals((long)-1L, (long)Iter.firstIndex((Iterator)iter, this.filter));
    }

    @Test
    public void first_05() {
        List<String> data = Arrays.asList("11", "A", "B", "C");
        Assert.assertEquals((long)1L, (long)Iter.firstIndex(data, this.filter));
    }

    @Test
    public void first_06() {
        List<String> data = Arrays.asList("11", "AA", "BB", "CC");
        Assert.assertEquals((long)-1L, (long)Iter.firstIndex(data, this.filter));
    }

    @Test
    public void last_01() {
        Iter iter = Iter.nullIter();
        Assert.assertEquals(null, (Object)Iter.last((Iterator)iter, this.filter));
    }

    @Test
    public void last_02() {
        List<String> data = Arrays.asList("11", "A", "B", "C");
        Assert.assertEquals((Object)"C", (Object)Iter.last(data, this.filter));
    }

    @Test
    public void last_03() {
        List<String> data = Arrays.asList("11", "AA", "BB", "CC");
        Assert.assertEquals(null, (Object)Iter.last(data, this.filter));
    }

    @Test
    public void last_04() {
        Iter iter = Iter.nullIter();
        Assert.assertEquals((long)-1L, (long)Iter.lastIndex((Iterator)iter, this.filter));
    }

    @Test
    public void last_05() {
        List<String> data = Arrays.asList("11", "A", "B", "C");
        Assert.assertEquals((long)3L, (long)Iter.lastIndex(data, this.filter));
    }

    @Test
    public void last_06() {
        List<String> data = Arrays.asList("11", "AA", "BB", "CC");
        Assert.assertEquals((long)-1L, (long)Iter.lastIndex(data, this.filter));
    }

    @Test
    public void take_01() {
        List<String> data = Arrays.asList("1", "A", "B", "CC");
        List data2 = Iter.take(data.iterator(), (int)2);
        Assert.assertEquals((long)2L, (long)data2.size());
        Assert.assertEquals((Object)"1", data2.get(0));
        Assert.assertEquals((Object)"A", data2.get(1));
    }

    @Test
    public void take_02() {
        List<String> data = Arrays.asList("1", "A", "B", "CC");
        List data2 = Iter.take(data.iterator(), (int)0);
        Assert.assertEquals((long)0L, (long)data2.size());
    }

    @Test
    public void take_03() {
        List<String> data = Arrays.asList("1", "A", "B", "CC");
        List data2 = Iter.take(data.iterator(), (int)10);
        Assert.assertEquals((long)4L, (long)data2.size());
        Assert.assertEquals((Object)"1", data2.get(0));
        Assert.assertEquals((Object)"A", data2.get(1));
        Assert.assertEquals((Object)"B", data2.get(2));
        Assert.assertEquals((Object)"CC", data2.get(3));
    }

    @Test
    public void filter_01() {
        this.test(Iter.removeNulls(this.data3), "x", "y", "z");
    }

    @Test
    public void filter_02() {
        Iterator it = Iter.filter(this.data3, (Filter)new Filter<String>(){

            public boolean accept(String item) {
                return "x".equals(item) || "z".equals(item);
            }
        });
        this.test(it, "x", "z");
    }

    @Test
    public void filter_03() {
        Iterator it = Iter.filter(this.data3, (Filter)new Filter<String>(){

            public boolean accept(String item) {
                return null == item || "x".equals(item);
            }
        });
        this.test(it, null, "x", null, null, null, null);
    }

    @Test
    public void distinct_01() {
        List<String> x = Arrays.asList("a", "b", "a");
        Iterator iter = Iter.distinct(x);
        this.test(iter, "a", "b");
    }

    @Test
    public void distinct_02() {
        List<String> x = Arrays.asList("a", "b", "a");
        Iterator iter = Iter.distinctAdjacent(x);
        this.test(iter, "a", "b", "a");
    }

    @Test
    public void distinct_03() {
        List<String> x = Arrays.asList("a", "a", "b", "b", "b", "a", "a");
        Iterator iter = Iter.distinct(x);
        this.test(iter, "a", "b");
    }

    @Test
    public void distinct_04() {
        List<String> x = Arrays.asList("a", "a", "b", "b", "b", "a", "a");
        Iterator iter = Iter.distinctAdjacent(x);
        this.test(iter, "a", "b", "a");
    }

    @Test
    public void testFilterStack_01() {
        AlwaysAcceptFilter filter = new AlwaysAcceptFilter();
        AlwaysAcceptFilterStack filterStack = new AlwaysAcceptFilterStack(filter);
        Assert.assertTrue((boolean)filterStack.accept(new Object()));
    }

    @Test
    public void testFilterStack_02() {
        NeverAcceptFilter filter = new NeverAcceptFilter();
        AlwaysAcceptFilterStack filterStack = new AlwaysAcceptFilterStack(filter);
        Assert.assertFalse((boolean)filterStack.accept(new Object()));
    }

    private static class AlwaysAcceptFilterStack
    extends FilterStack<Object> {
        public AlwaysAcceptFilterStack(Filter<Object> f) {
            super(f);
        }

        public boolean acceptAdditional(Object o) {
            return true;
        }
    }

    private static class NeverAcceptFilter
    implements Filter<Object> {
        private NeverAcceptFilter() {
        }

        public boolean accept(Object o) {
            return false;
        }
    }

    private static class AlwaysAcceptFilter
    implements Filter<Object> {
        private AlwaysAcceptFilter() {
        }

        public boolean accept(Object o) {
            return true;
        }
    }
}

