/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.jena.atlas.io.InStreamUTF8;
import org.apache.jena.atlas.io.OutStreamUTF8;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.Chars;
import org.junit.Test;

public class TestStreamUTF8
extends BaseTest {
    static Charset utf8 = Chars.charsetUTF8;
    static CharsetDecoder dec = utf8.newDecoder();
    static CharsetEncoder enc = utf8.newEncoder();
    private static final String asciiBase = "abc";
    private static final String latinBase = "\u00c0\u00e9\u00ed\u00ff";
    private static final String latinExtraBase = "\u1ef9\ufb01\ufb02";
    private static final String greekBase = "\u03b1\u03b2\u03b3";
    private static final String hewbrewBase = "\u05d0\u05d1\u05d2";
    private static final String arabicBase = "\u0621\u0622\u0623";
    private static final String symbolsBase = "\u263a\u263b\u266a\u266b";
    private static final String chineseBase = "\u5b6b\u5b50\u5175\u6cd5";
    private static final String japaneseBase = "\u65e5\u672c";

    @Test
    public void test_in_00() {
        TestStreamUTF8.testIn("");
    }

    @Test
    public void test_in_01() {
        TestStreamUTF8.testIn(asciiBase);
    }

    @Test
    public void test_in_02() {
        TestStreamUTF8.testIn(latinBase);
    }

    @Test
    public void test_in_03() {
        TestStreamUTF8.testIn(latinExtraBase);
    }

    @Test
    public void test_in_04() {
        TestStreamUTF8.testIn(greekBase);
    }

    @Test
    public void test_in_05() {
        TestStreamUTF8.testIn(hewbrewBase);
    }

    @Test
    public void test_in_06() {
        TestStreamUTF8.testIn(arabicBase);
    }

    @Test
    public void test_in_07() {
        TestStreamUTF8.testIn(symbolsBase);
    }

    @Test
    public void test_in_08() {
        TestStreamUTF8.testIn(chineseBase);
    }

    @Test
    public void test_in_09() {
        TestStreamUTF8.testIn(japaneseBase);
    }

    @Test
    public void test_out_00() {
        TestStreamUTF8.testIn("");
    }

    @Test
    public void test_out_01() {
        TestStreamUTF8.testOut(asciiBase);
    }

    @Test
    public void test_out_02() {
        TestStreamUTF8.testOut(latinBase);
    }

    @Test
    public void test_out_03() {
        TestStreamUTF8.testOut(latinExtraBase);
    }

    @Test
    public void test_out_04() {
        TestStreamUTF8.testOut(greekBase);
    }

    @Test
    public void test_out_05() {
        TestStreamUTF8.testOut(hewbrewBase);
    }

    @Test
    public void test_out_06() {
        TestStreamUTF8.testOut(arabicBase);
    }

    @Test
    public void test_out_07() {
        TestStreamUTF8.testOut(symbolsBase);
    }

    @Test
    public void test_out_08() {
        TestStreamUTF8.testOut(chineseBase);
    }

    @Test
    public void test_out_09() {
        TestStreamUTF8.testOut(japaneseBase);
    }

    static void testIn(String x) {
        try {
            byte[] bytes = TestStreamUTF8.stringAsBytes(x);
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            try (InStreamUTF8 r = new InStreamUTF8((InputStream)bin);){
                char[] cbuff = new char[x.length() * 10];
                int len = r.read(cbuff);
                String str = new String(cbuff, 0, len);
                TestStreamUTF8.assertEquals((Object)x, (Object)str);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static void testOut(String x) {
        try {
            byte[] bytes = TestStreamUTF8.stringAsBytes(x);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try (OutStreamUTF8 out = new OutStreamUTF8((OutputStream)bout);){
                out.write(x);
            }
            byte[] bytes2 = bout.toByteArray();
            TestStreamUTF8.assertArrayEquals((byte[])bytes, (byte[])bytes2);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static byte[] stringAsBytes(String x) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, utf8);){
                out.write(x);
            }
            byte[] bytes = bout.toByteArray();
            return bytes;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

