/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestIndentedWriter
extends BaseTest {
    @Test
    public void write01() {
        try (IndentedLineBuffer b = new IndentedLineBuffer();){
            b.print("hell");
            b.print("o");
            TestIndentedWriter.assertEquals((Object)"hello", (Object)b.asString());
        }
    }

    @Test
    public void write02() {
        try (IndentedLineBuffer b = new IndentedLineBuffer();){
            b.incIndent();
            b.print("hell");
            b.print("o");
            b.decIndent();
            TestIndentedWriter.assertEquals((Object)"  hello", (Object)b.asString());
        }
    }

    @Test
    public void write03() {
        try (IndentedLineBuffer b = new IndentedLineBuffer();){
            b.incIndent();
            b.printf("0x%04X", new Object[]{1});
            b.println();
            b.print("XX");
            b.decIndent();
            TestIndentedWriter.assertEquals((Object)"  0x0001\n  XX", (Object)b.asString());
        }
    }
}

