/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.jena.atlas.io.BufferingWriter;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestBufferingWriter
extends BaseTest {
    StringWriter sw = null;
    BufferingWriter w = null;

    public void create(int size, int blobSize) {
        this.sw = new StringWriter();
        this.w = new BufferingWriter((Writer)this.sw, size, blobSize);
    }

    public String string() {
        return this.sw.toString();
    }

    @Test
    public void write_01() {
        this.create(10, 5);
        this.w.output("x");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"x", (Object)x);
    }

    @Test
    public void write_02() {
        this.create(10, 5);
        this.w.output("foofoo");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"foofoo", (Object)x);
    }

    @Test
    public void write_03() {
        this.create(10, 8);
        this.w.output("a");
        this.w.output("b");
        this.w.output("c");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"abc", (Object)x);
    }

    @Test
    public void write_04() {
        this.create(10, 8);
        this.w.output("abcdefghijklmnopqrstuvwxyz");
        this.w.output("XYZ");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"abcdefghijklmnopqrstuvwxyzXYZ", (Object)x);
    }

    @Test
    public void write_05() {
        this.create(10, 8);
        this.w.output("");
        this.w.flush();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"", (Object)x);
    }

    @Test
    public void write_06() {
        this.create(100, 50);
        this.w.output("test");
        this.w.close();
        String x = this.string();
        TestBufferingWriter.assertEquals((Object)"test", (Object)x);
    }
}

