/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.jena.atlas.io.BlockUTF8;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.Chars;
import org.junit.Test;

public class TestBlockUTF8
extends BaseTest {
    static Charset utf8 = Chars.charsetUTF8;
    static CharsetDecoder dec = utf8.newDecoder();
    static CharsetEncoder enc = utf8.newEncoder();
    private static final String asciiBase = "abc";
    private static final String latinBase = "\u00c0\u00e9\u00ed\u00ff";
    private static final String latinExtraBase = "\u1ef9\ufb01\ufb02";
    private static final String greekBase = "\u03b1\u03b2\u03b3";
    private static final String hewbrewBase = "\u05d0\u05d1\u05d2";
    private static final String arabicBase = "\u0621\u0622\u0623";
    private static final String symbolsBase = "\u263a\u263b\u266a\u266b";
    private static final String chineseBase = "\u5b6b\u5b50\u5175\u6cd5";
    private static final String japaneseBase = "\u65e5\u672c";
    private static final String binaryStr1 = "abc\ud800xyz";
    private static final String binaryStr2 = "\ud800";
    private static final String binaryStr3 = "\u0000";
    private static final byte[] binaryBytes1 = new byte[0];
    private static final byte[] binaryBytes2 = new byte[]{0};
    private static final byte[] binaryBytes3 = new byte[]{-64, -128};
    static Alloc<ByteBuffer> allocByteBufferArray = new Alloc<ByteBuffer>(){

        @Override
        public ByteBuffer allocate(int len) {
            return ByteBuffer.allocate(len);
        }
    };
    static Alloc<ByteBuffer> allocByteBufferDirect = new Alloc<ByteBuffer>(){

        @Override
        public ByteBuffer allocate(int len) {
            return ByteBuffer.allocateDirect(len);
        }
    };
    static Alloc<CharBuffer> allocCharBufferArray = new Alloc<CharBuffer>(){

        @Override
        public CharBuffer allocate(int len) {
            return CharBuffer.allocate(len);
        }
    };
    static Alloc<CharBuffer> allocCharBufferDirect = new Alloc<CharBuffer>(){

        @Override
        public CharBuffer allocate(int len) {
            return ByteBuffer.allocateDirect(2 * len).asCharBuffer();
        }
    };

    @Test
    public void convert_in_00() {
        TestBlockUTF8.testIn("");
    }

    @Test
    public void convert_in_01() {
        TestBlockUTF8.testIn(asciiBase);
    }

    @Test
    public void convert_in_02() {
        TestBlockUTF8.testIn(latinBase);
    }

    @Test
    public void convert_in_03() {
        TestBlockUTF8.testIn(latinExtraBase);
    }

    @Test
    public void convert_in_04() {
        TestBlockUTF8.testIn(greekBase);
    }

    @Test
    public void convert_in_05() {
        TestBlockUTF8.testIn(hewbrewBase);
    }

    @Test
    public void convert_in_06() {
        TestBlockUTF8.testIn(arabicBase);
    }

    @Test
    public void convert_in_07() {
        TestBlockUTF8.testIn(symbolsBase);
    }

    @Test
    public void convert_in_08() {
        TestBlockUTF8.testIn(chineseBase);
    }

    @Test
    public void convert_in_09() {
        TestBlockUTF8.testIn(japaneseBase);
    }

    @Test
    public void convert_in_10() {
        TestBlockUTF8.testInOutBinary(binaryStr1);
    }

    @Test
    public void convert_in_11() {
        TestBlockUTF8.testInOutBinary(binaryStr2);
    }

    @Test
    public void convert_in_12() {
        TestBlockUTF8.testInOutBinary(binaryStr3);
    }

    @Test
    public void convert_out_00() {
        TestBlockUTF8.testOut("");
    }

    @Test
    public void convert_out_01() {
        TestBlockUTF8.testOut(asciiBase);
    }

    @Test
    public void convert_out_02() {
        TestBlockUTF8.testOut(latinBase);
    }

    @Test
    public void convert_out_03() {
        TestBlockUTF8.testOut(latinExtraBase);
    }

    @Test
    public void convert_out_04() {
        TestBlockUTF8.testOut(greekBase);
    }

    @Test
    public void convert_out_05() {
        TestBlockUTF8.testOut(hewbrewBase);
    }

    @Test
    public void convert_out_06() {
        TestBlockUTF8.testOut(arabicBase);
    }

    @Test
    public void convert_out_07() {
        TestBlockUTF8.testOut(symbolsBase);
    }

    @Test
    public void convert_out_08() {
        TestBlockUTF8.testOut(chineseBase);
    }

    @Test
    public void convert_out_09() {
        TestBlockUTF8.testOut(japaneseBase);
    }

    @Test
    public void convert_out_10() {
        TestBlockUTF8.testOut(binaryStr1);
    }

    @Test
    public void convert_out_11() {
        TestBlockUTF8.testOut(binaryStr2);
    }

    @Test
    public void convert_out_12() {
        TestBlockUTF8.testOut(binaryStr3);
    }

    @Test
    public void binary_01() {
        TestBlockUTF8.testBinary(binaryBytes1);
    }

    @Test
    public void binary_02() {
        TestBlockUTF8.testBinary(binaryBytes2);
    }

    @Test
    public void binary_03() {
        TestBlockUTF8.testBinary(binaryBytes3, binaryBytes2);
    }

    @Test
    public void binary_10() {
        TestBlockUTF8.testBinary(binaryBytes2, CharBuffer.wrap(binaryStr3));
    }

    @Test
    public void binary_11() {
        TestBlockUTF8.testBinary(binaryBytes3, CharBuffer.wrap(binaryStr3));
    }

    static void testIn(String x) {
        TestBlockUTF8.testIn(x, allocByteBufferArray, allocCharBufferArray);
        TestBlockUTF8.testIn(x, allocByteBufferDirect, allocCharBufferDirect);
    }

    static void testIn(String x, Alloc<ByteBuffer> allocBB, Alloc<CharBuffer> allocCB) {
        TestBlockUTF8.testInOutBinary(x);
        ByteBuffer bytes = ByteBuffer.wrap(TestBlockUTF8.stringAsBytes(x));
        int N = x.length();
        CharBuffer cb = CharBuffer.wrap(x.toCharArray());
        ByteBuffer bb = allocBB.allocate(4 * N);
        BlockUTF8.fromChars((CharBuffer)cb, (ByteBuffer)bb);
        bb.flip();
        TestBlockUTF8.assertTrue((String)"Bytes", (boolean)TestBlockUTF8.sameBytes(bytes, bb));
        CharBuffer cb2 = allocCB.allocate(N);
        BlockUTF8.toChars((ByteBuffer)bb, (CharBuffer)cb2);
        cb2.flip();
        String str = cb2.toString();
        TestBlockUTF8.assertEquals((Object)x, (Object)str);
    }

    static void testInOutBinary(String x) {
        int N = x.length();
        CharBuffer cb = CharBuffer.wrap(x.toCharArray());
        ByteBuffer bb = ByteBuffer.allocate(4 * N);
        BlockUTF8.fromChars((CharBuffer)cb, (ByteBuffer)bb);
        bb.flip();
        CharBuffer cb2 = CharBuffer.allocate(N);
        BlockUTF8.toChars((ByteBuffer)bb, (CharBuffer)cb2);
        String str = new String(cb2.array(), 0, cb2.position());
        TestBlockUTF8.assertEquals((Object)x, (Object)str);
        CharBuffer cb3 = CharBuffer.wrap(x.toCharArray());
        ByteBuffer bb3 = ByteBuffer.allocate(4 * N);
        BlockUTF8.fromChars((CharBuffer)cb3, (ByteBuffer)bb3);
        bb3.flip();
        TestBlockUTF8.assertArrayEquals((byte[])bb.array(), (byte[])bb3.array());
    }

    static void testOut(String x) {
        TestBlockUTF8.testOut(x, allocByteBufferArray, allocCharBufferArray);
        TestBlockUTF8.testOut(x, allocByteBufferDirect, allocCharBufferDirect);
    }

    static void testOut(String x, Alloc<ByteBuffer> allocBB, Alloc<CharBuffer> allocCB) {
        TestBlockUTF8.testBinary(TestBlockUTF8.stringAsBytes(x));
        int N = x.length();
        ByteBuffer bytes = ByteBuffer.wrap(TestBlockUTF8.stringAsBytes(x));
        CharBuffer cb = allocCB.allocate(N);
        BlockUTF8.toChars((ByteBuffer)bytes, (CharBuffer)cb);
        cb.flip();
        bytes.flip();
        String str = cb.toString();
        ByteBuffer bytes2 = allocBB.allocate(bytes.capacity());
        BlockUTF8.fromChars((CharBuffer)cb, (ByteBuffer)bytes2);
        bytes2.flip();
        TestBlockUTF8.assertTrue((String)"Chars", (boolean)TestBlockUTF8.sameBytes(bytes, bytes2));
    }

    static void testBinary(byte[] binary, CharBuffer chars) {
        int N = binary.length;
        ByteBuffer bytes = ByteBuffer.wrap(binary);
        CharBuffer cb = CharBuffer.allocate(N);
        BlockUTF8.toChars((ByteBuffer)bytes, (CharBuffer)cb);
        cb.flip();
        TestBlockUTF8.assertTrue((String)"Binary", (boolean)TestBlockUTF8.sameChars(chars, cb));
    }

    static void testBinary(byte[] binary) {
        TestBlockUTF8.testBinary(binary, binary);
    }

    static void testBinary(byte[] binary, byte[] expected) {
        int N = binary.length;
        ByteBuffer bytes = ByteBuffer.wrap(binary);
        CharBuffer cb = CharBuffer.allocate(N);
        BlockUTF8.toChars((ByteBuffer)bytes, (CharBuffer)cb);
        cb.flip();
        bytes.position(0);
        ByteBuffer bytes2 = ByteBuffer.allocate(2 * N);
        BlockUTF8.fromChars((CharBuffer)cb, (ByteBuffer)bytes2);
        bytes2.flip();
        TestBlockUTF8.sameBytes(bytes, bytes2);
        TestBlockUTF8.assertTrue((String)"Binary", (boolean)TestBlockUTF8.sameBytes(ByteBuffer.wrap(expected), bytes2));
    }

    static boolean sameBytes(ByteBuffer bb1, ByteBuffer bb2) {
        if (bb1.remaining() != bb2.remaining()) {
            return false;
        }
        for (int i = 0; i < bb1.remaining(); ++i) {
            if (bb1.get(i + bb1.position()) == bb2.get(i + bb2.position())) continue;
            return false;
        }
        return true;
    }

    static boolean sameChars(CharBuffer cb1, CharBuffer cb2) {
        if (cb1.remaining() != cb2.remaining()) {
            return false;
        }
        for (int i = 0; i < cb1.remaining(); ++i) {
            if (cb1.get(i + cb1.position()) == cb2.get(i + cb2.position())) continue;
            return false;
        }
        return true;
    }

    static byte[] stringAsBytes(String x) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, utf8);){
                out.write(x);
            }
            byte[] bytes = bout.toByteArray();
            return bytes;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static interface Alloc<T extends Buffer> {
        public T allocate(int var1);
    }
}

