/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.csv.CSVParser;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestCSVParser
extends BaseTest {
    String[] row1 = new String[0];
    String[] row2 = new String[]{""};
    String[] row3 = new String[]{"a", "b"};
    String[] row4 = new String[]{"123", "\"aa\"", "'bb'", "\"''\"Z", "A'\"\"'"};

    @Test
    public void csv_parse_01() {
        this.csv("\n", new String[][]{{""}});
    }

    @Test
    public void csv_parse_02() {
        this.csv("a\n", new String[][]{{"a"}});
    }

    @Test
    public void csv_parse_03() {
        this.csv("a,b\n", new String[][]{{"a", "b"}});
    }

    @Test
    public void csv_parse_04() {
        this.csv(",b\n", new String[][]{{"", "b"}});
    }

    @Test
    public void csv_parse_05() {
        this.csv("a,\n", new String[][]{{"a", ""}});
    }

    @Test
    public void csv_parse_06() {
        this.csv(",\n", new String[][]{{"", ""}});
    }

    @Test
    public void csv_parse_07() {
        this.csv(",,\n", new String[][]{{"", "", ""}});
    }

    @Test
    public void csv_parse_10() {
        this.csv("\n\n", new String[][]{{""}, {""}});
    }

    @Test
    public void csv_parse_11() {
        this.csv("'aa'\naa\n", new String[][]{{"'aa'"}, {"aa"}});
    }

    @Test
    public void csv_parse_12() {
        this.csv("\naa", new String[][]{{""}, {"aa"}});
    }

    @Test
    public void csv_parse_13() {
        this.csv("a,b\nc,d", new String[][]{{"a", "b"}, {"c", "d"}});
    }

    @Test
    public void csv_parse_14() {
        this.csv("a,b\rc,d", new String[][]{{"a", "b"}, {"c", "d"}});
    }

    private void csv(String input, String[][] strings) {
        ArrayList<List<String>> x = new ArrayList<List<String>>();
        for (String[] a : strings) {
            ArrayList<String> y = new ArrayList<String>();
            for (String b : a) {
                y.add(b);
            }
            x.add(y);
        }
        TestCSVParser.csv(input, x);
    }

    private static void csv(String input, List<List<String>> answers) {
        ArrayList<List> x = new ArrayList<List>();
        CSVParser parser = CSVParser.create((Reader)new StringReader(input));
        for (List row : parser) {
            x.add(row);
        }
        TestCSVParser.assertEquals(answers, x);
    }
}

