/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class TestUtils {
    @Test
    public void testCalendarToXSDDateTimeString_1() throws Exception {
        Calendar cal = TestUtils.createCalendar(1984, 2, 22, 14, 32, 1, 0, "Z");
        Assert.assertEquals((Object)"1984-03-22T14:32:01+00:00", (Object)Utils.calendarToXSDDateTimeString((Calendar)cal));
        cal.setTimeZone(TimeZone.getTimeZone("MST"));
        Assert.assertEquals((Object)"1984-03-22T07:32:01-07:00", (Object)Utils.calendarToXSDDateTimeString((Calendar)cal));
    }

    @Test
    public void testCalendarToXSDDateTimeString_2() throws Exception {
        Calendar cal = TestUtils.createCalendar(1984, 2, 22, 14, 32, 1, 50, "Z");
        Assert.assertEquals((Object)"1984-03-22T14:32:01.050+00:00", (Object)Utils.calendarToXSDDateTimeString((Calendar)cal));
        cal.setTimeZone(TimeZone.getTimeZone("MST"));
        Assert.assertEquals((Object)"1984-03-22T07:32:01.050-07:00", (Object)Utils.calendarToXSDDateTimeString((Calendar)cal));
    }

    @Test
    public void testCalendarToXSDDateString() throws Exception {
        Calendar cal = TestUtils.createCalendar(1984, 2, 22, 23, 59, 1, 0, "Z");
        cal.setTimeZone(TimeZone.getTimeZone("Z"));
        Assert.assertEquals((Object)"1984-03-22+00:00", (Object)Utils.calendarToXSDDateString((Calendar)cal));
        cal.setTimeZone(TimeZone.getTimeZone("MST"));
        Assert.assertEquals((Object)"1984-03-22-07:00", (Object)Utils.calendarToXSDDateString((Calendar)cal));
    }

    @Test
    public void testCalendarToXSDTimeString_1() throws Exception {
        Calendar cal = TestUtils.createCalendar(1984, 2, 22, 14, 32, 1, 0, "GMT+01:00");
        Assert.assertEquals((Object)"14:32:01+01:00", (Object)Utils.calendarToXSDTimeString((Calendar)cal));
        cal.setTimeZone(TimeZone.getTimeZone("MST"));
        Assert.assertEquals((Object)"06:32:01-07:00", (Object)Utils.calendarToXSDTimeString((Calendar)cal));
    }

    @Test
    public void testCalendarToXSDTimeString_2() throws Exception {
        Calendar cal = TestUtils.createCalendar(1984, 2, 22, 14, 32, 1, 500, "GMT+01:00");
        Assert.assertEquals((Object)"14:32:01.500+01:00", (Object)Utils.calendarToXSDTimeString((Calendar)cal));
        cal.setTimeZone(TimeZone.getTimeZone("MST"));
        Assert.assertEquals((Object)"06:32:01.500-07:00", (Object)Utils.calendarToXSDTimeString((Calendar)cal));
    }

    private static Calendar createCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int milli, String tz) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone(tz));
        cal.set(year, month, dayOfMonth, hourOfDay, minute, second);
        cal.set(14, milli);
        return cal;
    }
}

