/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.eval.PathEval;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestPathPF
extends BaseTest {
    static Graph graph1 = GraphFactory.createDefaultGraph();
    static Node elt1 = SSE.parseNode((String)"'elt1'");
    static Node elt2 = SSE.parseNode((String)"'elt2'");
    static String base = "http://example/";
    static Node node0 = NodeFactory.createURI((String)(base + "node0"));
    static Node node1 = NodeFactory.createURI((String)(base + "node1"));
    static Node node2 = NodeFactory.createURI((String)(base + "node2"));
    static Node s1 = NodeFactory.createURI((String)"http://example/s1");
    static Node s2 = NodeFactory.createURI((String)"http://example/s2");
    static Node s3 = NodeFactory.createURI((String)"http://example/s3");
    private static String data = "prefix : <http://example/>\n:s1 :p (1 2 3) .\n:s2 :p () .\n:s1 :p (4 5) .\n:s3 :p (8 9) .\n";
    private static Graph graph2 = Factory.createDefaultGraph();

    @BeforeClass
    public static void beforeClass() {
        Model m = ModelFactory.createModelForGraph((Graph)graph1);
        Bag bag0 = m.createBag(base + "node0");
        Bag bag1 = m.createBag(base + "node1");
        Seq seq2 = m.createSeq(base + "node2");
        bag1.add("elt1");
        seq2.add("elt1");
        seq2.add("elt2");
    }

    @AfterClass
    public static void afterClass() {
        graph1 = null;
    }

    @Test
    public void path_pf_00() {
        Path path = SSE.parsePath((String)"(link rdfs:member)");
        TestPathPF.eval(graph1, node0, path, new Node[0]);
    }

    @Test
    public void path_pf_01() {
        Path path = SSE.parsePath((String)"(path+ rdfs:member)");
        TestPathPF.eval(graph1, Node.ANY, path, elt1, elt2);
    }

    @Test
    public void path_pf_02() {
        Path path = SSE.parsePath((String)"(link rdfs:member)");
        TestPathPF.evalReverse(graph1, elt1, path, node1, node2);
    }

    @Test
    public void path_pf_03() {
        Path path = SSE.parsePath((String)"(link rdfs:member)");
        TestPathPF.evalReverse(graph1, Node.ANY, path, node2, node2, node1);
    }

    @Test
    public void path_pf_10() {
        Path path = SSE.parsePath((String)"(prefix ((list: <http://jena.hpl.hp.com/ARQ/list#>)) (seq :p (link list:member)))");
        TestPathPF.eval(graph2, s1, path, "1", "2", "3", "4", "5");
    }

    @Test
    public void path_pf_11() {
        Path path = SSE.parsePath((String)"(prefix ((list: <http://jena.hpl.hp.com/ARQ/list#>)) (seq :p (link list:member)))");
        TestPathPF.eval(graph2, s2, path, new Node[0]);
    }

    @Test
    public void path_pf_12() {
        Path path = SSE.parsePath((String)"(prefix ((list: <http://jena.hpl.hp.com/ARQ/list#>)) (seq :p (link list:member)))");
        TestPathPF.eval(graph2, s3, path, "8", "9");
    }

    @Test
    public void path_pf_13() {
        Path path = SSE.parsePath((String)"(prefix ((list: <http://jena.hpl.hp.com/ARQ/list#>)) (seq :p (link list:member)))");
        TestPathPF.evalReverse(graph2, NodeConst.nodeOne, path, s1);
    }

    @Test
    public void path_pf_14() {
        Path path = SSE.parsePath((String)"(prefix ((list: <http://jena.hpl.hp.com/ARQ/list#>)) (seq :p (link list:member)))");
        TestPathPF.evalReverse(graph2, NodeConst.nodeNil, path, new Node[0]);
    }

    private static void eval(Graph graph, Node start, Path path, String ... expected) {
        Node[] r = new Node[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            r[i] = SSE.parseNode((String)expected[i]);
        }
        TestPathPF.eval(graph, start, path, r);
    }

    private static void evalReverse(Graph graph, Node start, Path path, Node ... expected) {
        Iterator iter = PathEval.evalReverse((Graph)graph, (Node)start, (Path)path, null);
        TestPathPF.check((Iterator<Node>)iter, expected);
    }

    private static void eval(Graph graph, Node start, Path path, Node ... expected) {
        Iterator iter = PathEval.eval((Graph)graph, (Node)start, (Path)path, (Context)ARQ.getContext());
        TestPathPF.check((Iterator<Node>)iter, expected);
    }

    private static void check(Iterator<Node> iter, Node ... expected) {
        TestPathPF.check(iter, Arrays.asList(expected));
    }

    private static void check(Iterator<Node> iter, List<Node> expected) {
        List x = Iter.toList(iter);
        TestPathPF.assertEqualsUnordered(expected, x);
    }

    static {
        RDFDataMgr.read((Graph)graph2, (StringReader)new StringReader(data), null, (Lang)Lang.TTL);
    }
}

