/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.modify.AbstractTestUpdateBase;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateException;
import org.junit.Test;

public abstract class AbstractTestUpdateGraphMgt
extends AbstractTestUpdateBase {
    static final Node graphIRI = NodeFactory.createURI((String)"http://example/graph");

    @Test
    public void testCreateDrop1() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateCreate u = new UpdateCreate(graphIRI);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        AbstractTestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        AbstractTestUpdateGraphMgt.assertTrue((boolean)AbstractTestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        boolean silentMode = true;
        if (!silentMode) {
            try {
                UpdateAction.execute((Update)u, (GraphStore)gStore);
                AbstractTestUpdateGraphMgt.fail();
            }
            catch (UpdateException ex) {
                // empty catch block
            }
        }
        u = new UpdateDrop(graphIRI);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        AbstractTestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
        if (!silentMode) {
            try {
                UpdateAction.execute((Update)u, (GraphStore)gStore);
                AbstractTestUpdateGraphMgt.fail();
            }
            catch (UpdateException ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateDrop2() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateCreate u = new UpdateCreate(graphIRI);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        u = new UpdateCreate(graphIRI, true);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        AbstractTestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        AbstractTestUpdateGraphMgt.assertTrue((boolean)AbstractTestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        u = new UpdateDrop(graphIRI);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
        AbstractTestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
        u = new UpdateDrop(graphIRI, true);
        UpdateAction.execute((Update)u, (GraphStore)gStore);
    }

    @Test
    public void testCreateDrop3() {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraphMgt.script(gStore, "create-1.ru");
        AbstractTestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        AbstractTestUpdateGraphMgt.assertTrue((boolean)AbstractTestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
    }

    @Test
    public void testCreateDrop4() {
        GraphStore gStore = this.getEmptyGraphStore();
        gStore.addGraph(graphIRI, GraphFactory.createDefaultGraph());
        AbstractTestUpdateGraphMgt.script(gStore, "drop-1.ru");
        AbstractTestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
    }
}

