/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.modify.AbstractTestUpdateBase;
import com.hp.hpl.jena.sparql.modify.request.QuadAcc;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateCopy;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.junit.Test;

public abstract class AbstractTestUpdateGraph
extends AbstractTestUpdateBase {
    protected static Node s = NodeFactoryExtra.parseNode((String)"<http://example/r>");
    protected static Node p = NodeFactoryExtra.parseNode((String)"<http://example/p>");
    protected static Node q = NodeFactoryExtra.parseNode((String)"<http://example/q>");
    protected static Node v = NodeFactoryExtra.parseNode((String)"<http://example/v>");
    protected static Node o1 = NodeFactoryExtra.parseNode((String)"2007");
    protected static Triple triple1 = new Triple(s, p, o1);
    protected static Node o2 = NodeFactoryExtra.parseNode((String)"1066");
    protected static Triple triple2 = new Triple(s, p, o2);
    protected static Graph graph1 = AbstractTestUpdateGraph.data1();
    protected static Node graphIRI = NodeFactoryExtra.parseNode((String)"<http://example/graph>");

    @Test
    public void testInsertData1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple2);
        UpdateDataInsert insert = new UpdateDataInsert(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)insert, (GraphStore)gStore);
        uProc.execute();
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDeleteData1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple2);
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)delete, (GraphStore)gStore);
        uProc.execute();
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDeleteData2() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple1);
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)delete, (GraphStore)gStore);
        uProc.execute();
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert1() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateModify insert = new UpdateModify();
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testInsert2() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addTriple(triple1);
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert3() {
        GraphStore gStore = this.getEmptyGraphStore();
        gStore.addGraph(graphIRI, Factory.createDefaultGraph());
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    @Test
    public void testInsert4() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> 1066)"));
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> 2007 }");
        insert.setElement(element);
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDelete1() {
        GraphStore gStore = this.getEmptyGraphStore();
        QuadAcc acc = new QuadAcc();
        UpdateDeleteWhere delete = new UpdateDeleteWhere(acc);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete2() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadAcc acc = new QuadAcc();
        UpdateDeleteWhere delete = new UpdateDeleteWhere(acc);
        acc.addTriple(SSE.parseTriple((String)"(?s ?p ?o)"));
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((String)"Not empty", (boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete3() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        acc.addTriple(triple1);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete4() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.namedGraphData(gStore, graphIRI, AbstractTestUpdateGraph.data1());
        QuadDataAcc acc = new QuadDataAcc();
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        acc.setGraph(graphIRI);
        acc.addTriple(triple1);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete5() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, AbstractTestUpdateGraph.data1());
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> 2007 )"));
        UpdateAction.execute((Update)modify, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertTrue((String)"Not empty", (boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testModify1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, Factory.createDefaultGraph());
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        modify.getDeleteAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> ?o)"));
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> ?o)"));
        UpdateAction.execute((Update)modify, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    @Test
    public void testModify2() {
        Triple t = new Triple(NodeFactory.createAnon(), p, o2);
        GraphStore gStore = this.getEmptyGraphStore();
        gStore.getContext().set(ARQ.spillToDiskThreshold, (Object)0L);
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data(t));
        this.namedGraphData(gStore, graphIRI, AbstractTestUpdateGraph.data(t));
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        modify.getDeleteAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> ?o)"));
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> ?o)"));
        UpdateAction.execute((Update)modify, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), t));
    }

    @Test
    public void testModifyInitialBindings() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data12());
        this.namedGraphData(gStore, graphIRI, Factory.createDefaultGraph());
        Binding initialBinding = BindingFactory.binding((Var)Var.alloc((String)"o"), (Node)o1);
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        modify.getDeleteAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> ?o)"));
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> ?o)"));
        UpdateAction.execute((Update)modify, (GraphStore)gStore, (Binding)initialBinding);
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testCopy() {
        Triple t = new Triple(NodeFactory.createAnon(), p, o2);
        Triple t2 = new Triple(NodeFactory.createAnon(), p, o1);
        GraphStore gStore = this.getEmptyGraphStore();
        gStore.getContext().set(ARQ.spillToDiskThreshold, (Object)0L);
        this.defaultGraphData(gStore, AbstractTestUpdateGraph.data(triple1, triple2, t));
        this.namedGraphData(gStore, graphIRI, AbstractTestUpdateGraph.data(t2));
        UpdateCopy copy = new UpdateCopy(Target.DEFAULT, Target.create((Node)graphIRI));
        UpdateAction.execute((Update)copy, (GraphStore)gStore);
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple2));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), t));
        AbstractTestUpdateGraph.assertFalse((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), t2));
        AbstractTestUpdateGraph.assertTrue((boolean)gStore.getDefaultGraph().isIsomorphicWith(gStore.getGraph(graphIRI)));
    }

    @Test
    public void testUpdateScript1() {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraph.script(gStore, "update-1.ru");
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript2() {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraph.script(gStore, "update-2.ru");
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(NodeFactory.createURI((String)"http://example/g1")), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript3() {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraph.script(gStore, "update-3.ru");
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getGraph(NodeFactory.createURI((String)"http://example/g1"))));
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript4() {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraph.script(gStore, "data-1.ru");
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript5() {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraph.script(gStore, "data-2.ru");
        Graph g = GraphFactory.createPlainGraph();
        Node b = NodeFactory.createAnon();
        g.add(new Triple(s, p, b));
        g.add(new Triple(b, q, v));
        AbstractTestUpdateGraph.assertTrue((boolean)g.isIsomorphicWith(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript6() {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraph.script(gStore, "data-3.ru");
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript7() {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraph.script(gStore, "data-4.ru");
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactoryExtra.parseNode((String)"123"))));
        Graph g = gStore.getGraph(graphIRI);
        AbstractTestUpdateGraph.assertTrue((boolean)AbstractTestUpdateGraph.graphContains(gStore.getGraph(graphIRI), new Triple(s, p, o2)));
    }

    @Test(expected=QueryException.class)
    public void testUpdateBad1() {
        this.testBad("bad-1.ru", 1);
    }

    @Test
    public void testUpdateBad2() {
        this.testBad("bad-2.ru", 1);
    }

    @Test
    public void testUpdateBad3() {
        this.testBad("bad-3.ru", 0);
    }

    private void testBad(String file, int expectedSize) {
        GraphStore gStore = this.getEmptyGraphStore();
        AbstractTestUpdateGraph.script(gStore, file);
        AbstractTestUpdateGraph.assertEquals((long)expectedSize, (long)AbstractTestUpdateGraph.countQuads((DatasetGraph)gStore));
    }

    private static long countQuads(DatasetGraph dsg) {
        return Iter.count((Iterator)dsg.find());
    }

    private static Graph data1() {
        return AbstractTestUpdateGraph.data(triple1);
    }

    private static Graph data2() {
        return AbstractTestUpdateGraph.data(triple2);
    }

    private static Graph data12() {
        return AbstractTestUpdateGraph.data(triple1, triple2);
    }

    private static Graph data(Triple ... triples) {
        Graph graph = Factory.createDefaultGraph();
        for (Triple t : triples) {
            graph.add(t);
        }
        return graph;
    }
}

