/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateAction;
import org.apache.jena.atlas.junit.BaseTest;

public abstract class AbstractTestUpdateBase
extends BaseTest {
    protected static final String FileBase = "testing/Update";

    protected abstract GraphStore getEmptyGraphStore();

    protected void defaultGraphData(GraphStore gStore, Graph data) {
        Graph g = gStore.getDefaultGraph();
        g.clear();
        GraphUtil.addInto((Graph)g, (Graph)data);
    }

    protected void namedGraphData(GraphStore gStore, Node uri, Graph data) {
        Graph g = gStore.getGraph(uri);
        if (g == null) {
            gStore.addGraph(uri, GraphFactory.createJenaDefaultGraph());
            g = gStore.getGraph(uri);
        } else {
            g.clear();
        }
        GraphUtil.addInto((Graph)g, (Graph)data);
    }

    protected static void script(GraphStore gStore, String filename) {
        UpdateAction.readExecute((String)("testing/Update/" + filename), (GraphStore)gStore);
    }

    protected static boolean graphEmpty(Graph graph) {
        return graph.isEmpty();
    }

    protected static boolean graphContains(Graph graph, Triple triple) {
        return graph.contains(triple);
    }
}

