/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.junit.QueryTestException;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.vocabulary.TestManifest;
import com.hp.hpl.jena.sparql.vocabulary.TestManifestX;
import com.hp.hpl.jena.sparql.vocabulary.VocabTestQuery;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.junit.TestException;
import com.hp.hpl.jena.util.junit.TestUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;

public class TestItem {
    static int counter = 0;
    private Resource testResource = null;
    private Resource actionResource = null;
    private String name;
    private boolean buildLuceneIndex = false;
    private String resultFile;
    private String comment;
    private List<String> defaultGraphURIs;
    private List<String> namedGraphURIs;
    private Resource testType = null;
    private String queryFile;
    private Syntax queryFileSyntax;

    public static String fakeURI() {
        return "test:" + ++counter;
    }

    public static TestItem create(Resource entry, Resource defaultTestType) {
        return new TestItem(entry, defaultTestType);
    }

    public static TestItem create(String _name, String _queryFile, String _dataFile, String _resultFile) {
        return new TestItem(_name, _queryFile, _dataFile, _resultFile);
    }

    private TestItem(Resource entry, Resource defaultTestType) {
        this.testResource = entry;
        if (!entry.hasProperty(TestManifest.name)) {
            throw new QueryTestException("TestItem with no name (" + entry + ")");
        }
        this.name = this._getName();
        if (!entry.hasProperty(TestManifest.action)) {
            throw new QueryTestException("TestItem '" + this.name + "' with no action");
        }
        this.testType = TestUtils.getResource((Resource)entry, (Property)RDF.type);
        if (this.testType == null) {
            this.testType = defaultTestType;
        }
        this.resultFile = this._getResultFile();
        this.comment = this._getComment();
        this.defaultGraphURIs = this._getDefaultGraphURIs();
        this.namedGraphURIs = this._getNamedGraphsURIs();
        this.queryFile = this._getQueryFile();
        this.queryFileSyntax = this._getQuerySyntax(entry.getModel(), this.queryFile, Syntax.syntaxARQ);
        this.buildLuceneIndex = this._getTextIndex();
    }

    private TestItem(String _name, String _queryFile, String _dataFile, String _resultFile) {
        this.name = _name;
        this.queryFile = _queryFile;
        this.defaultGraphURIs = new ArrayList<String>();
        this.defaultGraphURIs.add(_dataFile);
        this.namedGraphURIs = new ArrayList<String>();
        this.resultFile = _resultFile;
        this.comment = "";
        this.queryFileSyntax = Syntax.guessFileSyntax((String)_queryFile);
    }

    public Resource getResource() {
        return this.testResource;
    }

    public Resource getAction() {
        return this._getAction();
    }

    public Resource getTestType() {
        return this.testType;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public Syntax getFileSyntax() {
        return this.queryFileSyntax;
    }

    public void setFileSyntax(Syntax syntax) {
        this.queryFileSyntax = syntax;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public SPARQLResult getResults() {
        if (this.resultFile == null) {
            return null;
        }
        ResultsFormat format = ResultsFormat.guessSyntax((String)this.resultFile);
        if (ResultsFormat.isRDFGraphSyntax((ResultsFormat)format)) {
            Model m = FileManager.get().loadModel(this.resultFile);
            return new SPARQLResult(m);
        }
        SPARQLResult x = ResultSetFactory.result((String)this.resultFile);
        return x;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        if (this.testResource != null && this.testResource.isURIResource()) {
            return this.testResource.getURI();
        }
        return TestItem.fakeURI();
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getDefaultGraphURIs() {
        return this.defaultGraphURIs;
    }

    public List<String> getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean requiresTextIndex() {
        return this.buildLuceneIndex;
    }

    private String _getName() {
        Statement s = this.testResource.getProperty(TestManifest.name);
        if (s == null) {
            return "<<unset>>";
        }
        return s.getString();
    }

    private Resource _getAction() {
        if (this.actionResource == null) {
            this.actionResource = this.testResource.getProperty(TestManifest.action).getResource();
        }
        return this.actionResource;
    }

    private String _getResultFile() {
        try {
            return TestUtils.getLiteralOrURI((Resource)this.testResource, (Property)TestManifest.result);
        }
        catch (TestException ex) {
            return null;
        }
    }

    private String _getComment() {
        Statement s = this.testResource.getProperty(RDFS.comment);
        if (s == null) {
            return null;
        }
        return s.getString();
    }

    private List<String> _getDefaultGraphURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = this._getAction().listProperties(VocabTestQuery.data);
        while (cIter.hasNext()) {
            Statement stmt = (Statement)cIter.next();
            String df = stmt.getResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }

    private List<String> _getNamedGraphsURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = this._getAction().listProperties(VocabTestQuery.graphData);
        while (cIter.hasNext()) {
            Statement obj = (Statement)cIter.next();
            String df = obj.getResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }

    private String _getQueryFile() {
        Resource r = this._getAction();
        if (r.hasProperty(VocabTestQuery.query)) {
            return TestUtils.getLiteralOrURI((Resource)r, (Property)VocabTestQuery.query);
        }
        if (this._getAction().isAnon()) {
            return "[]";
        }
        return this._getAction().getURI();
    }

    private Syntax _getQuerySyntax(Model m, String uri, Syntax def) {
        Syntax synFileName;
        Resource r = m.createResource(uri);
        if (r.hasProperty(TestManifestX.querySyntax)) {
            Syntax x = Syntax.make((String)r.getProperty(TestManifestX.querySyntax).getResource().getURI());
            return x;
        }
        if (uri != null && (synFileName = Syntax.guessFileSyntax((String)uri)) != null) {
            return synFileName;
        }
        return def;
    }

    private boolean _getTextIndex() {
        Statement s = this.testResource.getProperty(TestManifestX.textIndex);
        if (s == null) {
            return false;
        }
        return s.getString().equalsIgnoreCase("true");
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        String name = this.getName();
        sbuff.append("Name: " + name);
        if (this.getComment() != null) {
            sbuff.append("    Comment: " + this.getComment());
        }
        return sbuff.toString();
    }
}

