/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.user;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.E_Multiply;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunction;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunctionDefinition;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunctionFactory;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFunctionNonExpansion {
    @BeforeClass
    public static void setup() {
        UserDefinedFunctionFactory.getFactory().clear();
        UserDefinedFunctionFactory.getFactory().setPreserveDependencies(true);
    }

    @AfterClass
    public static void teardown() {
        UserDefinedFunctionFactory.getFactory().clear();
        UserDefinedFunctionFactory.getFactory().setPreserveDependencies(false);
    }

    @Test
    public void test_function_non_expansion_01() {
        E_Multiply square = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
        E_Multiply cube = new E_Multiply((Expr)new E_Function("http://example/square", new ExprList((Expr)new ExprVar("x"))), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/cube", (Expr)cube, new ArrayList(cube.getVarsMentioned()));
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/cube");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Multiply));
        E_Multiply multiply = (E_Multiply)base;
        Assert.assertTrue((boolean)(multiply.getArg1() instanceof E_Function));
        Assert.assertTrue((boolean)(multiply.getArg2() instanceof ExprVar));
        E_Function lhs = (E_Function)multiply.getArg1();
        Assert.assertEquals((Object)"http://example/square", (Object)lhs.getFunctionIRI());
        Assert.assertEquals((long)1L, (long)base.getVarsMentioned().size());
    }

    @Test
    public void test_function_non_expansion_02() {
        E_Multiply square = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
        E_Multiply cube = new E_Multiply((Expr)new E_Function("http://example/square", new ExprList((Expr)new ExprVar("x"))), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/cube", (Expr)cube, new ArrayList(cube.getVarsMentioned()));
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/cube");
        f.build("http://example/cube", new ExprList((Expr)new NodeValueInteger(2L)));
        Expr actual = f.getActualExpr();
        NodeValue result = actual.eval((Binding)BindingFactory.create(), FunctionEnvBase.createTest());
        Assert.assertEquals((long)8L, (long)NodeFactoryExtra.nodeToInt((Node)result.asNode()));
        square = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
        f.build("http://example/cube", new ExprList((Expr)new NodeValueInteger(2L)));
        actual = f.getActualExpr();
        result = actual.eval((Binding)BindingFactory.create(), FunctionEnvBase.createTest());
        Assert.assertEquals((long)4L, (long)NodeFactoryExtra.nodeToInt((Node)result.asNode()));
    }
}

