/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFunctions {
    private static final NodeValue INT_ZERO = NodeValue.makeInteger((long)0L);
    private static final NodeValue INT_ONE = NodeValue.makeInteger((long)1L);
    private static final NodeValue TRUE = NodeValue.TRUE;
    private static final NodeValue FALSE = NodeValue.FALSE;
    static Node xyz_en = NodeFactory.createLiteral((String)"xyz", (String)"en");
    static NodeValue nv_xyz_en = NodeValue.makeNode((Node)xyz_en);
    static Node xyz_xsd_string = NodeFactory.createLiteral((String)"xyz", (RDFDatatype)XSDDatatype.XSDstring);
    static NodeValue nv_xyz_string = NodeValue.makeNode((Node)xyz_xsd_string);
    static Node n_uri = NodeFactory.createURI((String)"http://example/");
    static NodeValue nv_uri = NodeValue.makeNode((Node)n_uri);

    @Test
    public void expr1() {
        this.test("1", NodeValue.makeInteger((long)1L));
    }

    @Test
    public void exprStrLen1() {
        this.test("fn:string-length('')", INT_ZERO);
    }

    @Test
    public void exprStrLen2() {
        this.test("fn:string-length('a')", INT_ONE);
    }

    @Test
    public void exprStrLen3() {
        this.test("fn:string-length('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32')", NodeValue.makeInteger((long)10L));
    }

    @Test
    public void exprSubstring1() {
        this.test("fn:substring('',0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring2() {
        this.test("fn:substring('',1)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring3() {
        this.test("fn:substring('',1,0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring4() {
        this.test("fn:substring('',1,1)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring5() {
        this.test("fn:substring('abc',1)", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprSubstring6() {
        this.test("fn:substring('abc',2)", NodeValue.makeString((String)"bc"));
    }

    @Test
    public void exprSubstring7() {
        this.test("fn:substring('a',1,1)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprSubstring8() {
        this.test("fn:substring('a',1,2)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprSubstring9() {
        this.test("fn:substring('a',0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring10() {
        this.test("fn:substring('abc',1.6,1.33)", NodeValue.makeString((String)"b"));
    }

    @Test
    public void exprSubstring11() {
        this.test("fn:substring('abc',-1, -15.3)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprSubstring12() {
        this.test("fn:substring('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32', 1, 1)", NodeValue.makeString((String)"\ud801\udc08"));
    }

    @Test
    public void exprJavaSubstring1() {
        this.test("afn:substr('abc',0,0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprJavaSubstring2() {
        this.test("afn:substr('abc',0,1)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprJavaSubstring3() {
        this.test("<java:com.hp.hpl.jena.sparql.function.library.substr>('abc',0,0)", NodeValue.makeString((String)""));
    }

    @Test
    public void exprJavaSubstring4() {
        this.test("<java:com.hp.hpl.jena.sparql.function.library.substr>('abc',0,1)", NodeValue.makeString((String)"a"));
    }

    @Test
    public void exprJavaSubstring5() {
        this.test("afn:substr('\ud801\udc08\ud801\udc4c\ud801\udc3b\ud801\udc2a\ud801\udc49\ud801\udc3f\ud801\udc3b\ud801\udc2e\ud801\udc3f\ud801\udc32', 0, 1)", NodeValue.makeString((String)"\ud801\udc08"));
    }

    @Test
    public void exprStrStart0() {
        this.test("fn:starts-with('abc', '')", TRUE);
    }

    @Test
    public void exprStrStart1() {
        this.test("fn:starts-with('abc', 'a')", TRUE);
    }

    @Test
    public void exprStrStart2() {
        this.test("fn:starts-with('abc', 'ab')", TRUE);
    }

    @Test
    public void exprStrStart3() {
        this.test("fn:starts-with('abc', 'abc')", TRUE);
    }

    @Test
    public void exprStrStart4() {
        this.test("fn:starts-with('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprStrStart10() {
        this.test("STRSTARTS('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprStrStart11() {
        this.test("STRSTARTS('abc'@en, 'ab')", TRUE);
    }

    @Test
    public void exprStrStart12() {
        this.test("STRSTARTS('abc'^^xsd:string, 'ab')", TRUE);
    }

    @Test
    public void exprStrStart13() {
        this.test("STRSTARTS('abc'^^xsd:string, 'ab'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrStart14() {
        this.test("STRSTARTS('abc', 'ab'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrStart15() {
        this.test("STRSTARTS('abc'@en, 'ab'@en)", TRUE);
    }

    @Test
    public void exprStrStart16() {
        this.testEvalException("STRSTARTS('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrStart17() {
        this.testEvalException("STRSTARTS(123, 'ab'@fr)");
    }

    @Test
    public void exprStrStart18() {
        this.testEvalException("STRSTARTS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrBefore0() {
        this.test("STRBEFORE('abc', 'abcd')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore1() {
        this.test("STRBEFORE('abc'@en, 'b')", NodeValue.makeNode((String)"a", (String)"en", (String)null));
    }

    @Test
    public void exprStrBefore2() {
        this.test("STRBEFORE('abc'^^xsd:string, 'c')", NodeValue.makeNode((String)"ab", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrBefore3() {
        this.test("STRBEFORE('abc'^^xsd:string, ''^^xsd:string)", NodeValue.makeNode((String)"", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrBefore4() {
        this.test("STRBEFORE('abc', 'ab'^^xsd:string)", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore5() {
        this.test("STRBEFORE('abc'@en, 'b'@en)", NodeValue.makeNode((String)"a", (String)"en", (String)null));
    }

    @Test
    public void exprStrBefore6() {
        this.testEvalException("STRBEFORE('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrBefore7() {
        this.testEvalException("STRBEFORE(123, 'ab'@fr)");
    }

    @Test
    public void exprStrBefore8() {
        this.testEvalException("STRBEFORE('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrBefore9() {
        this.test("STRBEFORE('abc'^^xsd:string, 'z')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrBefore10() {
        this.test("STRBEFORE('abc'^^xsd:string, '')", NodeValue.makeNode((String)"", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter0() {
        this.test("STRAFTER('abc', 'abcd')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter1() {
        this.test("STRAFTER('abc'@en, 'b')", NodeValue.makeNode((String)"c", (String)"en", (String)null));
    }

    @Test
    public void exprStrAfter2() {
        this.test("STRAFTER('abc'^^xsd:string, 'a')", NodeValue.makeNode((String)"bc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter3() {
        this.test("STRAFTER('abc'^^xsd:string, ''^^xsd:string)", NodeValue.makeNode((String)"abc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrAfter4() {
        this.test("STRAFTER('abc', 'bc'^^xsd:string)", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter5() {
        this.test("STRAFTER('abc'@en, 'b'@en)", NodeValue.makeNode((String)"c", (String)"en", (String)null));
    }

    @Test
    public void exprStrAfter6() {
        this.testEvalException("STRAFTER('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrAfter7() {
        this.testEvalException("STRAFTER(123, 'ab'@fr)");
    }

    @Test
    public void exprStrAfter8() {
        this.testEvalException("STRAFTER('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrAfter9() {
        this.test("STRAFTER('abc'^^xsd:string, 'z')", NodeValue.nvEmptyString);
    }

    @Test
    public void exprStrAfter10() {
        this.test("STRAFTER('abc'^^xsd:string, '')", NodeValue.makeNode((String)"abc", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprStrEnds0() {
        this.test("fn:ends-with('abc', '')", TRUE);
    }

    @Test
    public void exprStrEnds1() {
        this.test("fn:ends-with('abc', 'c')", TRUE);
    }

    @Test
    public void exprStrEnds2() {
        this.test("fn:ends-with('abc', 'bc')", TRUE);
    }

    @Test
    public void exprStrEnds3() {
        this.test("fn:ends-with('abc', 'abc')", TRUE);
    }

    @Test
    public void exprStrEnds4() {
        this.test("fn:ends-with('abc', 'zabc')", FALSE);
    }

    @Test
    public void exprStrEnds10() {
        this.test("STRENDS('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprStrEnds11() {
        this.test("STRENDS('abc'@en, 'bc')", TRUE);
    }

    @Test
    public void exprStrEnds12() {
        this.test("STRENDS('abc'^^xsd:string, 'c')", TRUE);
    }

    @Test
    public void exprStrEnds13() {
        this.test("STRENDS('abc'^^xsd:string, 'c'^^xsd:string)", TRUE);
    }

    @Test
    public void exprStrEnds14() {
        this.test("STRENDS('abc', 'ab'^^xsd:string)", FALSE);
    }

    @Test
    public void exprStrEnds15() {
        this.test("STRENDS('abc'@en, 'abc'@en)", TRUE);
    }

    @Test
    public void exprStrEnds16() {
        this.testEvalException("STRENDS('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprStrEnds17() {
        this.testEvalException("STRENDS(123, 'ab'@fr)");
    }

    @Test
    public void exprStrEnds18() {
        this.testEvalException("STRENDS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprStrCase1() {
        this.test("fn:lower-case('aBc')", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprStrCase2() {
        this.test("fn:lower-case('abc')", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprStrCase3() {
        this.test("fn:upper-case('abc')", NodeValue.makeString((String)"ABC"));
    }

    @Test
    public void exprStrCase4() {
        this.test("fn:upper-case('ABC')", NodeValue.makeString((String)"ABC"));
    }

    @Test
    public void exprStrContains0() {
        this.test("fn:contains('abc', '')", TRUE);
    }

    @Test
    public void exprStrContains1() {
        this.test("fn:contains('abc', 'a')", TRUE);
    }

    @Test
    public void exprStrContains2() {
        this.test("fn:contains('abc', 'b')", TRUE);
    }

    @Test
    public void exprStrContains3() {
        this.test("fn:contains('abc', 'c')", TRUE);
    }

    @Test
    public void exprStrContains4() {
        this.test("fn:contains('abc', 'ab')", TRUE);
    }

    @Test
    public void exprStrContains5() {
        this.test("fn:contains('abc', 'bc')", TRUE);
    }

    @Test
    public void exprStrContains6() {
        this.test("fn:contains('abc', 'abc')", TRUE);
    }

    @Test
    public void exprStrContains7() {
        this.test("fn:contains('abc', 'Xc')", FALSE);
    }

    @Test
    public void exprStrContains8() {
        this.test("fn:contains('abc', 'Xa')", FALSE);
    }

    @Test
    public void exprContains10() {
        this.test("Contains('abc', 'abcd')", FALSE);
    }

    @Test
    public void exprContains11() {
        this.test("Contains('abc'@en, 'bc')", TRUE);
    }

    @Test
    public void exprContains12() {
        this.test("Contains('abc'^^xsd:string, 'c')", TRUE);
    }

    @Test
    public void exprContains13() {
        this.test("Contains('abc'^^xsd:string, 'c'^^xsd:string)", TRUE);
    }

    @Test
    public void exprContains14() {
        this.test("Contains('abc', 'z'^^xsd:string)", FALSE);
    }

    @Test
    public void exprContains15() {
        this.test("Contains('abc'@en, 'abc'@en)", TRUE);
    }

    @Test
    public void exprContains16() {
        this.testEvalException("Contains('ab'@en, 'ab'@fr)");
    }

    @Test
    public void exprContains17() {
        this.testEvalException("Contains(123, 'ab'@fr)");
    }

    @Test
    public void exprContains18() {
        this.testEvalException("STRENDS('123'^^xsd:string, 12.3)");
    }

    @Test
    public void exprReplace01() {
        this.test("REPLACE('abc', 'b', 'Z')", NodeValue.makeString((String)"aZc"));
    }

    @Test
    public void exprReplace02() {
        this.test("REPLACE('abc', 'b.', 'Z')", NodeValue.makeString((String)"aZ"));
    }

    @Test
    public void exprReplace03() {
        this.test("REPLACE('abcbd', 'b.', 'Z')", NodeValue.makeString((String)"aZZ"));
    }

    @Test
    public void exprReplace04() {
        this.test("REPLACE('abcbd'^^xsd:string, 'b.', 'Z')", NodeValue.makeNode((String)"aZZ", (RDFDatatype)XSDDatatype.XSDstring));
    }

    @Test
    public void exprReplace05() {
        this.test("REPLACE('abcbd'@en, 'b.', 'Z')", NodeValue.makeNode((String)"aZZ", (String)"en", (String)null));
    }

    @Test
    public void exprReplace06() {
        this.test("REPLACE('abcbd', 'B.', 'Z', 'i')", NodeValue.makeString((String)"aZZ"));
    }

    @Test
    public void exprReplace07() {
        this.test("REPLACE('abc', '.*', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprReplace08() {
        this.test("REPLACE('', '.*', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprReplace09() {
        this.test("REPLACE('abc', '.?', 'Z')", NodeValue.makeString((String)"ZZZ"));
    }

    @Test
    public void exprReplace10() {
        this.test("REPLACE('abc', 'XXX', 'Z')", NodeValue.makeString((String)"abc"));
    }

    @Test
    public void exprReplace11() {
        this.test("REPLACE('', '.', 'Z')", NodeValue.makeString((String)""));
    }

    @Test
    public void exprReplace12() {
        this.test("REPLACE('', '(a|b)?', 'Z')", NodeValue.makeString((String)"Z"));
    }

    @Test
    public void exprReplace13() {
        this.testEvalException("REPLACE('abc', '.*', '$1')");
    }

    @Test
    public void exprBoolean1() {
        this.test("fn:boolean('')", FALSE);
    }

    @Test
    public void exprBoolean2() {
        this.test("fn:boolean(0)", FALSE);
    }

    @Test
    public void exprBoolean3() {
        this.test("fn:boolean(''^^xsd:string)", FALSE);
    }

    @Test
    public void exprBoolean4() {
        this.test("fn:boolean('X')", TRUE);
    }

    @Test
    public void exprBoolean5() {
        this.test("fn:boolean('X'^^xsd:string)", TRUE);
    }

    @Test
    public void exprBoolean6() {
        this.test("fn:boolean(1)", TRUE);
    }

    @Test
    public void exprBoolean7() {
        this.test("fn:not('')", TRUE);
    }

    @Test
    public void exprBoolean8() {
        this.test("fn:not('X')", FALSE);
    }

    @Test
    public void exprBoolean9() {
        this.test("fn:not(1)", FALSE);
    }

    @Test
    public void exprBoolean10() {
        this.test("fn:not(0)", TRUE);
    }

    @Test
    public void exprSameTerm1() {
        this.test("sameTerm(1,1)", TRUE);
    }

    @Test
    public void exprSameTerm2() {
        this.test("sameTerm(1,1.0)", FALSE);
    }

    @Test
    public void exprSameTerm3() {
        this.test("sameTerm(1,1e0)", FALSE);
    }

    @Test
    public void exprSameTerm4() {
        this.test("sameTerm(<_:a>, <_:a>)", TRUE);
    }

    @Test
    public void exprSameTerm5() {
        this.test("sameTerm(<x>, <x>)", TRUE);
    }

    @Test
    public void exprSameTerm6() {
        this.test("sameTerm(<x>, <y>)", FALSE);
    }

    @Test
    public void exprOneOf_01() {
        this.test("57 in (xsd:integer, '123')", FALSE);
    }

    @Test
    public void exprOneOf_02() {
        this.test("57 in (57)", TRUE);
    }

    @Test
    public void exprOneOf_03() {
        this.test("57 in (123, 57)", TRUE);
    }

    @Test
    public void exprOneOf_04() {
        this.test("57 in (57, 456)", TRUE);
    }

    @Test
    public void exprOneOf_05() {
        this.test("57 in (123, 57, 456)", TRUE);
    }

    @Test
    public void exprOneOf_06() {
        this.test("57 in (1,2,3)", FALSE);
    }

    @Test
    public void exprNotOneOf_01() {
        this.test("57 not in (xsd:integer, '123')", TRUE);
    }

    @Test
    public void exprNotOneOf_02() {
        this.test("57 not in (57)", FALSE);
    }

    @Test
    public void exprNotOneOf_03() {
        this.test("57 not in (123, 57)", FALSE);
    }

    @Test
    public void exprNotOneOf_04() {
        this.test("57 not in (57, 456)", FALSE);
    }

    @Test
    public void exprNotOneOf_05() {
        this.test("57 not in (123, 57, 456)", FALSE);
    }

    @Test
    public void exprNotOneOf_06() {
        this.test("57 not in (1,2,3)", TRUE);
    }

    @Test
    public void exprStrLang1() {
        this.test("strlang('xyz', 'en')", nv_xyz_en);
    }

    @Test
    public void exprStrDatatype1() {
        this.test("strdt('123', xsd:integer)", NodeValue.makeInteger((long)123L));
    }

    @Test
    public void exprStrDatatype2() {
        this.test("strdt('xyz', xsd:string)", nv_xyz_string);
    }

    @Test
    public void exprStrDatatype3() {
        this.testEvalException("strdt('123', 'datatype')");
    }

    @Test
    public void exprIRI1() {
        this.test("iri('http://example/')", nv_uri);
    }

    private void test(String exprStr, NodeValue result) {
        Expr expr = ExprUtils.parse((String)exprStr);
        NodeValue r = expr.eval(null, FunctionEnvBase.createTest());
        Assert.assertEquals((Object)result, (Object)r);
    }

    private void testEvalException(String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr);
        try {
            NodeValue r = expr.eval(null, FunctionEnvBase.createTest());
            Assert.fail((String)"No exception raised");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }
}

