/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformCopy;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.sse.SSE;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestExprTransform
extends BaseTest {
    ExprTransform et1 = new ExprTransformCopy(){

        public Expr transform(ExprVar exprVar) {
            return new ExprVar(exprVar.getVarName().toUpperCase());
        }
    };

    @Test
    public void exprTransform_01() {
        this.test("?v", "?V", this.et1);
    }

    @Test
    public void exprTransform_02() {
        this.test("(+ ?v 1)", "(+ ?V 1)", this.et1);
    }

    @Test
    public void exprTransform_03() {
        this.test("(str (+ ?v 1))", "(str (+ ?V 1))", this.et1);
    }

    @Test
    public void exprTransform_04() {
        this.test("(if (+ ?v 1) ?a ?b)", "(if (+ ?V 1) ?A ?B)", this.et1);
    }

    @Test
    public void exprTransform_05() {
        this.test("(regex ?a ?b ?c)", "(regex ?A ?B ?C)", this.et1);
    }

    @Test
    public void exprTransform_06() {
        this.test("(regex ?a ?b)", "(regex ?A ?B)", this.et1);
    }

    private void test(String string, String string2, ExprTransform et) {
        Expr e1 = SSE.parseExpr((String)string);
        Expr e2 = SSE.parseExpr((String)string2);
        Expr e3 = ExprTransformer.transform((ExprTransform)et, (Expr)e1);
        TestExprTransform.assertEquals((Object)e2, (Object)e3);
    }
}

