/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import com.hp.hpl.jena.sparql.engine.http.Service;
import com.hp.hpl.jena.sparql.modify.UpdateProcessRemoteBase;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestService {
    private static final String SERVICE = "http://example.com:40000";
    private static Object value;

    @BeforeClass
    public static void recordContextState() {
        value = ARQ.getContext().get(Service.serviceContext);
    }

    @AfterClass
    public static void restoreContextState() {
        ARQ.getContext().set(Service.serviceContext, value);
    }

    @Test
    public void testNumericTimeout() {
        block2: {
            BasicPattern basicPattern = new BasicPattern();
            basicPattern.add(Triple.ANY);
            Node serviceNode = NodeFactory.createURI((String)SERVICE);
            OpService opService = new OpService(serviceNode, (Op)new OpBGP(basicPattern), false);
            Context context = new Context();
            ARQ.setNormalMode((Context)context);
            context.set(Service.queryTimeout, (Object)10);
            try {
                Service.exec((OpService)opService, (Context)context);
                Assert.fail((String)"Expected QueryExceptionHTTP");
            }
            catch (QueryExceptionHTTP expected) {
                Throwable thrown = expected.getCause();
                if (thrown instanceof SocketException || thrown instanceof ConnectTimeoutException) break block2;
                Assert.fail((String)String.format("Expected SocketException or ConnectTimeoutException, instead got: %s %s", thrown.getClass().getName(), thrown.getMessage()));
            }
        }
    }

    @Test
    public void testStringTimeout() {
        block2: {
            BasicPattern basicPattern = new BasicPattern();
            basicPattern.add(Triple.ANY);
            Node serviceNode = NodeFactory.createURI((String)SERVICE);
            OpService opService = new OpService(serviceNode, (Op)new OpBGP(basicPattern), false);
            Context context = new Context();
            ARQ.setNormalMode((Context)context);
            context.set(Service.queryTimeout, (Object)"10");
            try {
                Service.exec((OpService)opService, (Context)context);
                Assert.fail((String)"Expected QueryExceptionHTTP");
            }
            catch (QueryExceptionHTTP expected) {
                Throwable thrown = expected.getCause();
                if (thrown instanceof SocketException || thrown instanceof ConnectTimeoutException) break block2;
                Assert.fail((String)String.format("Expected SocketException or ConnectTimeoutException, instead got: %s %s", thrown.getClass().getName(), thrown.getMessage()));
            }
        }
    }

    @Test
    public void testStringTimeout2() {
        block2: {
            BasicPattern basicPattern = new BasicPattern();
            basicPattern.add(Triple.ANY);
            Node serviceNode = NodeFactory.createURI((String)SERVICE);
            OpService opService = new OpService(serviceNode, (Op)new OpBGP(basicPattern), false);
            Context context = new Context();
            ARQ.setNormalMode((Context)context);
            context.set(Service.queryTimeout, (Object)"10,10000");
            try {
                Service.exec((OpService)opService, (Context)context);
                Assert.fail((String)"Expected QueryExceptionHTTP");
            }
            catch (QueryExceptionHTTP expected) {
                Throwable thrown = expected.getCause();
                if (thrown instanceof SocketException || thrown instanceof ConnectTimeoutException) break block2;
                Assert.fail((String)String.format("Expected SocketException or ConnectTimeoutException, instead got: %s %s", thrown.getClass().getName(), thrown.getMessage()));
            }
        }
    }

    @Test
    public void query_service_context_application_01() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap != null) {
            serviceContextMap.remove(SERVICE);
        }
        Query q = QueryFactory.create((String)"ASK { }");
        QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((long)-1L, (long)engine.getTimeout1());
        Assert.assertEquals((long)-1L, (long)engine.getTimeout2());
        Assert.assertTrue((boolean)engine.getAllowGZip());
        Assert.assertTrue((boolean)engine.getAllowDeflate());
        Assert.assertFalse((boolean)engine.isUsingBasicAuthentication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_service_context_application_02() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            serviceContext.put(Service.queryAuthUser, (Object)"user");
            serviceContext.put(Service.queryAuthPwd, (Object)"password");
            Query q = QueryFactory.create((String)"ASK { }");
            QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((long)-1L, (long)engine.getTimeout1());
            Assert.assertEquals((long)-1L, (long)engine.getTimeout2());
            Assert.assertTrue((boolean)engine.getAllowGZip());
            Assert.assertTrue((boolean)engine.getAllowDeflate());
            Assert.assertTrue((boolean)engine.isUsingBasicAuthentication());
        }
        finally {
            serviceContext.remove(Service.queryAuthUser);
            serviceContext.remove(Service.queryAuthPwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_service_context_application_03() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            serviceContext.put(Service.queryTimeout, (Object)"10");
            Query q = QueryFactory.create((String)"ASK { }");
            QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((long)-1L, (long)engine.getTimeout1());
            Assert.assertEquals((long)10L, (long)engine.getTimeout2());
            Assert.assertTrue((boolean)engine.getAllowGZip());
            Assert.assertTrue((boolean)engine.getAllowDeflate());
            Assert.assertFalse((boolean)engine.isUsingBasicAuthentication());
        }
        finally {
            serviceContext.remove(Service.queryTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_service_context_application_04() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            serviceContext.put(Service.queryTimeout, (Object)"10,20");
            Query q = QueryFactory.create((String)"ASK { }");
            QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((long)20L, (long)engine.getTimeout1());
            Assert.assertEquals((long)10L, (long)engine.getTimeout2());
            Assert.assertTrue((boolean)engine.getAllowGZip());
            Assert.assertTrue((boolean)engine.getAllowDeflate());
            Assert.assertFalse((boolean)engine.isUsingBasicAuthentication());
        }
        finally {
            serviceContext.remove(Service.queryTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_service_context_application_05() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            serviceContext.put(Service.queryGzip, (Object)false);
            serviceContext.put(Service.queryDeflate, (Object)false);
            Query q = QueryFactory.create((String)"ASK { }");
            QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)SERVICE, (Query)q);
            Assert.assertNotNull((Object)engine);
            Assert.assertEquals((long)-1L, (long)engine.getTimeout1());
            Assert.assertEquals((long)-1L, (long)engine.getTimeout2());
            Assert.assertFalse((boolean)engine.getAllowGZip());
            Assert.assertFalse((boolean)engine.getAllowDeflate());
            Assert.assertFalse((boolean)engine.isUsingBasicAuthentication());
        }
        finally {
            serviceContext.remove(Service.queryGzip);
            serviceContext.remove(Service.queryDeflate);
        }
    }

    @Test
    public void update_service_context_application_01() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap != null) {
            serviceContextMap.remove(SERVICE);
        }
        UpdateRequest updates = UpdateFactory.create((String)"CREATE GRAPH <http://example>");
        UpdateProcessRemoteBase engine = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)SERVICE);
        Assert.assertNotNull((Object)engine);
        Assert.assertFalse((boolean)engine.isUsingAuthentication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void update_service_context_application_02() {
        Map serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        if (serviceContextMap == null) {
            ARQ.getContext().put(Service.serviceContext, new HashMap());
            serviceContextMap = (Map)ARQ.getContext().get(Service.serviceContext);
        }
        if (serviceContextMap.get(SERVICE) == null) {
            serviceContextMap.put(SERVICE, new Context(ARQ.getContext()));
        }
        Context serviceContext = (Context)serviceContextMap.get(SERVICE);
        try {
            serviceContext.put(Service.queryAuthUser, (Object)"user");
            serviceContext.put(Service.queryAuthPwd, (Object)"password");
            UpdateRequest updates = UpdateFactory.create((String)"CREATE GRAPH <http://example>");
            UpdateProcessRemoteBase engine = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)SERVICE);
            Assert.assertNotNull((Object)engine);
            Assert.assertTrue((boolean)engine.isUsingAuthentication());
        }
        finally {
            serviceContext.remove(Service.queryAuthUser);
            serviceContext.remove(Service.queryAuthPwd);
        }
    }
}

