/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.table.TableEmpty;
import com.hp.hpl.jena.sparql.algebra.table.TableN;
import com.hp.hpl.jena.sparql.algebra.table.TableUnit;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.TableJoin;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.resultset.ResultSetCompare;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.HashSet;
import java.util.List;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestTableLib
extends BaseTest {
    Table unit = new TableUnit();
    Table zero = new TableEmpty();
    Table zeroData = SSE.parseTable((String)"(table)");
    Table unitData = SSE.parseTable((String)"(table (row))");
    Table data1 = SSE.parseTable((String)"(table (row (?a 1) (?b 2)))");
    Table data2 = SSE.parseTable((String)"(table (row (?a 1) (?c 3)) (row (?a 9) (?c 5))  )");
    Table data3 = SSE.parseTable((String)"(table (row (?a 1) (?c 3)) (row (?a 1) (?c 4)) (row (?a 9) (?c 5))  )");
    Table data1J2 = SSE.parseTable((String)"(table (row (?a 1) (?b 2) (?c 3)) )");
    Table data1LJ2 = SSE.parseTable((String)"(table (row (?a 1) (?b 2) (?c 3)) (row (?a 9) (?c 5)) )");
    Table data2LJ1 = SSE.parseTable((String)"(table (row (?a 1) (?b 2) (?c 3)) )");
    Table data1J3 = SSE.parseTable((String)"(table (row (?a 1) (?b 2) (?c 3)) (row (?a 1) (?b 2) (?c 4)) )");

    @Test
    public void table_01() {
        this.test(this.unit, this.zero, true, null, this.zero);
    }

    @Test
    public void table_02() {
        this.test(this.zero, this.unit, true, null, this.zero);
    }

    @Test
    public void table_03() {
        this.test(this.unit, this.zero, false, null, this.unit);
    }

    @Test
    public void table_04() {
        this.test(this.zero, this.unit, false, null, this.zero);
    }

    @Test
    public void table_05() {
        this.test(this.unitData, this.zeroData, true, null, this.zeroData);
    }

    @Test
    public void table_06() {
        this.test(this.zeroData, this.unitData, true, null, this.zeroData);
    }

    @Test
    public void table_07() {
        this.test(this.unitData, this.zeroData, false, null, this.unitData);
    }

    @Test
    public void table_08() {
        this.test(this.zeroData, this.unitData, false, null, this.zeroData);
    }

    @Test
    public void table_10() {
        this.test(this.data1, this.zero, true, null, this.zero);
    }

    @Test
    public void table_11() {
        this.test(this.zero, this.data1, true, null, this.zero);
    }

    @Test
    public void table_12() {
        this.test(this.data1, this.zero, false, null, this.data1);
    }

    @Test
    public void table_13() {
        this.test(this.zero, this.data1, false, null, this.zero);
    }

    @Test
    public void table_14() {
        this.test(this.data1, this.zeroData, true, null, this.zeroData);
    }

    @Test
    public void table_15() {
        this.test(this.zeroData, this.data1, true, null, this.zeroData);
    }

    @Test
    public void table_16() {
        this.test(this.data1, this.zeroData, false, null, this.data1);
    }

    @Test
    public void table_17() {
        this.test(this.zeroData, this.data1, false, null, this.zeroData);
    }

    @Test
    public void table_18() {
        this.test(this.data2, this.unitData, true, null, this.data2);
    }

    @Test
    public void table_19() {
        this.test(this.unitData, this.data2, true, null, this.data2);
    }

    @Test
    public void table_20() {
        this.test(this.data1, this.data2, true, null, this.data1J2);
    }

    @Test
    public void table_21() {
        this.test(this.data2, this.data1, true, null, this.data1J2);
    }

    @Test
    public void table_22() {
        this.test(this.data1, this.data2, false, null, this.data1LJ2);
    }

    @Test
    public void table_23() {
        this.test(this.data2, this.data1, false, null, this.data2LJ1);
    }

    @Test
    public void table_24() {
        this.test(this.data1, this.data3, true, null, this.data1J3);
    }

    @Test
    public void table_25() {
        this.test(this.data3, this.data1, true, null, this.data1J3);
    }

    private void test(Table left, Table right, boolean normalJoin, ExprList exprs, Table expected) {
        ExecutionContext execCxt = new ExecutionContext(ARQ.getContext(), null, null, null);
        QueryIterator leftIter = left.iterator(execCxt);
        QueryIterator qIter = normalJoin ? TableJoin.join((QueryIterator)leftIter, (Table)right, (ExprList)exprs, (ExecutionContext)execCxt) : TableJoin.leftJoin((QueryIterator)leftIter, (Table)right, (ExprList)exprs, (ExecutionContext)execCxt);
        HashSet vars1 = new HashSet();
        vars1.addAll(left.getVarNames());
        vars1.addAll(right.getVarNames());
        TableN results = new TableN(qIter);
        boolean b = TableCompare.equalsByTerm(expected, (Table)results);
        if (!b) {
            System.out.println("** Expected");
            System.out.println(expected);
            System.out.println("** Actual");
            System.out.println(results);
        }
        TestTableLib.assertTrue((boolean)b);
    }

    static class TableCompare {
        TableCompare() {
        }

        public static boolean equalsByTerm(Table table1, Table table2) {
            ResultSet rs1 = ResultSetFactory.create((QueryIterator)table1.iterator(null), (List)table1.getVarNames());
            ResultSet rs2 = ResultSetFactory.create((QueryIterator)table2.iterator(null), (List)table2.getVarNames());
            return ResultSetCompare.equalsByTerm((ResultSet)rs1, (ResultSet)rs2);
        }
    }
}

