/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.AbstractTestGraphOverDataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.GraphView;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.junit.Test;

public class TestDatasetGraphViewGraphs
extends AbstractTestGraphOverDataset {
    @Override
    protected DatasetGraph createBaseDSG() {
        return DatasetGraphFactory.createMem();
    }

    @Override
    protected Graph makeDefaultGraph(DatasetGraph dsg) {
        return GraphView.createDefaultGraph((DatasetGraph)dsg);
    }

    @Override
    protected Graph makeNamedGraph(DatasetGraph dsg, Node gn) {
        return GraphView.createNamedGraph((DatasetGraph)dsg, (Node)gn);
    }

    @Test
    public void graphDSG_basic_1() {
        Graph g = this.makeDefaultGraph(this.baseDSG);
        TestDatasetGraphViewGraphs.assertTrue((boolean)(g instanceof GraphView));
        GraphView gv = (GraphView)g;
        TestDatasetGraphViewGraphs.assertEquals((Object)this.baseDSG, (Object)gv.getDataset());
        TestDatasetGraphViewGraphs.assertEquals(null, (Object)gv.getGraphName());
    }

    @Test
    public void graphDSG_basic_2() {
        Node gn1 = SSE.parseNode((String)"<g1>");
        Graph g = this.makeNamedGraph(this.baseDSG, gn1);
        TestDatasetGraphViewGraphs.assertTrue((boolean)(g instanceof GraphView));
        GraphView gv = (GraphView)g;
        TestDatasetGraphViewGraphs.assertEquals((Object)this.baseDSG, (Object)gv.getDataset());
        TestDatasetGraphViewGraphs.assertEquals((Object)gn1, (Object)gv.getGraphName());
    }

    @Test
    public void graphDSG_view_union_2() {
        GraphView g = GraphView.createUnionGraph((DatasetGraph)this.baseDSG);
        TestDatasetGraphViewGraphs.assertTrue((boolean)(g instanceof GraphView));
        long x = Iter.count((Iterator)g.find(null, null, null));
        TestDatasetGraphViewGraphs.assertEquals((long)2L, (long)x);
    }

    @Test
    public void graphDSG_view_union_3() {
        GraphView g = GraphView.createUnionGraph((DatasetGraph)this.baseDSG);
        TestDatasetGraphViewGraphs.assertEquals((long)2L, (long)g.size());
    }
}

