/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphViewGraphs;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestGraphOverDataset
extends BaseTest {
    protected DatasetGraph baseDSG;
    private static Quad q0 = SSE.parseQuad((String)"(_ <s> <p> 0)");
    private static Quad q1 = SSE.parseQuad((String)"(<g1> <s> <p> 1)");
    private static Quad q2 = SSE.parseQuad((String)"(<g2> <s> <p> 2)");
    private static Quad q3 = SSE.parseQuad((String)"(<g3> <s> <p> 2)");
    private static Node gn1 = SSE.parseNode((String)"<g1>");
    private static Node gn2 = SSE.parseNode((String)"<g2>");
    private static Node gn3 = SSE.parseNode((String)"<g3>");
    private static Node gnNotSuchGraph = SSE.parseNode((String)"<NoSuchGraph>");

    protected abstract DatasetGraph createBaseDSG();

    protected abstract Graph makeNamedGraph(DatasetGraph var1, Node var2);

    protected abstract Graph makeDefaultGraph(DatasetGraph var1);

    @Before
    public void before() {
        this.baseDSG = this.createBaseDSG();
        this.baseDSG.add(q0);
        this.baseDSG.add(q1);
        this.baseDSG.add(q2);
        this.baseDSG.add(q3);
    }

    @Test
    public void graphDSG_view_1() {
        Triple t = (Triple)this.makeDefaultGraph(this.baseDSG).find(null, null, null).next();
        AbstractTestGraphOverDataset.assertEquals((Object)SSE.parseTriple((String)"(<s> <p> 0)"), (Object)t);
    }

    @Test
    public void graphDSG_view_2() {
        Triple t = (Triple)this.makeNamedGraph(this.baseDSG, gn1).find(null, null, null).next();
        AbstractTestGraphOverDataset.assertEquals((Object)SSE.parseTriple((String)"(<s> <p> 1)"), (Object)t);
    }

    @Test
    public void graphDSG_view_3() {
        Graph g = this.makeDefaultGraph(this.baseDSG);
        g.add(SSE.parseTriple((String)"(<s> <p> 99)"));
        long x = Iter.count((Iterator)this.baseDSG.find(Quad.defaultGraphNodeGenerated, null, null, null));
        AbstractTestGraphOverDataset.assertEquals((long)2L, (long)x);
        AbstractTestGraphOverDataset.assertEquals((long)2L, (long)g.size());
    }

    @Test
    public void graphDSG_view_4() {
        Graph g = this.makeNamedGraph(this.baseDSG, gnNotSuchGraph);
        long x = Iter.count((Iterator)this.baseDSG.find(gnNotSuchGraph, null, null, null));
        AbstractTestGraphOverDataset.assertEquals((long)0L, (long)x);
        AbstractTestGraphOverDataset.assertEquals((long)0L, (long)g.size());
    }

    @Test
    public void graphDSG_view_union_1() {
        Graph g = this.makeNamedGraph(this.baseDSG, Quad.unionGraph);
        ExtendedIterator iter = g.find(null, null, null);
        while (iter.hasNext()) {
            iter.next();
        }
        AbstractTestGraphOverDataset.assertEquals((long)2L, (long)g.size());
    }

    @Test
    public void graphDSG_contains_1() {
        boolean b = new DatasetGraphViewGraphs(this.baseDSG).containsGraph(gn1);
        AbstractTestGraphOverDataset.assertTrue((boolean)b);
    }

    @Test
    public void graphDSG_contains_2() {
        boolean b = new DatasetGraphViewGraphs(this.baseDSG).containsGraph(gnNotSuchGraph);
        AbstractTestGraphOverDataset.assertFalse((boolean)b);
    }

    @Test
    public void graphDSG_prefixes_1() {
        Graph g = this.makeNamedGraph(this.baseDSG, gn1);
        PrefixMapping pmap = g.getPrefixMapping();
        AbstractTestGraphOverDataset.assertNotNull((Object)pmap);
    }

    @Test
    public void graphDSG_prefixes_2() {
        Graph g = this.makeNamedGraph(this.baseDSG, Quad.unionGraph);
        PrefixMapping pmap = g.getPrefixMapping();
        AbstractTestGraphOverDataset.assertNotNull((Object)pmap);
    }

    @Test
    public void graphDSG_prefixes_3() {
        Graph g = this.makeDefaultGraph(this.baseDSG);
        PrefixMapping pmap = g.getPrefixMapping();
        AbstractTestGraphOverDataset.assertNotNull((Object)pmap);
    }

    @Test
    public void graphDSG_prefixes_4() {
        Graph g = this.makeNamedGraph(this.baseDSG, gnNotSuchGraph);
        PrefixMapping pmap = g.getPrefixMapping();
        AbstractTestGraphOverDataset.assertNotNull((Object)pmap);
    }

    @Test
    public void graphDGS_update_1() {
        Quad q9 = SSE.parseQuad((String)"(<g3> <s> <p> 9)");
        Graph g = this.makeNamedGraph(this.baseDSG, gn3);
        this.baseDSG.add(q9);
        Triple t = SSE.parseTriple((String)"(<s> <p> 9)");
        AbstractTestGraphOverDataset.assertTrue((boolean)g.contains(t));
    }

    @Test
    public void graphDGS_update_2() {
        Triple t = SSE.parseTriple((String)"(<s> <p> 9)");
        Graph g = this.makeNamedGraph(this.baseDSG, gn3);
        g.add(t);
        Quad q9 = SSE.parseQuad((String)"(<g3> <s> <p> 9)");
        AbstractTestGraphOverDataset.assertTrue((boolean)this.baseDSG.contains(q9));
    }
}

