/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.sse.SSE;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestDynamicDataset
extends BaseTest {
    Dataset dataset;

    protected abstract Dataset createDataset();

    @After
    public void after() {
    }

    @Before
    public void before() {
        this.dataset = this.createDataset();
        for (int i = 0; i < 5; ++i) {
            AbstractTestDynamicDataset.addGraph(this.dataset, i);
        }
        Model m = this.dataset.getDefaultModel();
        Triple t1 = SSE.parseTriple((String)"(<uri:x> <uri:p> 0)");
        Triple t2 = SSE.parseTriple((String)"(<uri:y> <uri:q> 'ABC')");
        Triple t3 = SSE.parseTriple((String)"(<uri:z> <uri:property> 'DEF')");
        m.getGraph().add(t1);
        m.getGraph().add(t2);
        m.getGraph().add(t3);
    }

    private static void addGraph(Dataset dataset, int i) {
        String x = "graph:" + i;
        Model m = dataset.getNamedModel(x);
        Triple t1 = SSE.parseTriple((String)("(<uri:x> <uri:p> " + i + ")"));
        Triple t2 = SSE.parseTriple((String)"(<uri:y> <uri:q> 'ABC')");
        m.getGraph().add(t1);
        m.getGraph().add(t2);
    }

    @Test
    public void dynamic01() {
        AbstractTestDynamicDataset.testCount("SELECT * {?s ?p ?o}", 3, this.dataset);
    }

    @Test
    public void dynamic02() {
        AbstractTestDynamicDataset.testCount("SELECT ?g { GRAPH ?g {} }", 5, this.dataset);
    }

    @Test
    public void dynamic03() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM <graph:1> {?s <uri:p> ?o}", 1, this.dataset);
    }

    @Test
    public void dynamic04() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM <graph:1> { GRAPH ?g { ?s ?p ?o} }", 0, this.dataset);
    }

    @Test
    public void dynamic05() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM <graph:1> FROM <graph:2> {?s <uri:p> ?o}", 2, this.dataset);
    }

    @Test
    public void dynamic06() {
        AbstractTestDynamicDataset.testCount("SELECT ?s FROM <graph:1> FROM <graph:2> {?s <uri:q> ?o}", 1, this.dataset);
    }

    @Test
    public void dynamic07() {
        AbstractTestDynamicDataset.testCount("SELECT ?s FROM NAMED <graph:1> {?s <uri:q> ?o}", 0, this.dataset);
    }

    @Test
    public void dynamic08() {
        AbstractTestDynamicDataset.testCount("SELECT ?s FROM <graph:2> FROM NAMED <graph:1> {?s <uri:q> ?o}", 1, this.dataset);
    }

    @Test
    public void dynamic09() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM <graph:1> FROM <graph:2> FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH ?g { ?s <uri:q> ?o }}", 2, this.dataset);
    }

    @Test
    public void dynamic10() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM <graph:1> FROM <graph:2>FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH ?g { ?s <uri:q> ?o }}", 2, this.dataset);
    }

    @Test
    public void dynamic11() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM <x:unknown>{ GRAPH ?g { ?s <uri:q> ?o }}", 0, this.dataset);
    }

    @Test
    public void dynamic12() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM  <graph:1>{ GRAPH ?g { }}", 0, this.dataset);
    }

    @Test
    public void dynamic13() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM NAMED <graph:1>{ GRAPH ?g { }}", 1, this.dataset);
    }

    @Test
    public void dynamic14() {
        AbstractTestDynamicDataset.testCount("SELECT * FROM NAMED <graph:1> FROM NAMED <graph:2>FROM <graph:3> { GRAPH ?g { }}", 2, this.dataset);
    }

    private static void testCount(String queryString, int expected, Dataset ds) {
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)ds);
        ResultSet rs = qExec.execSelect();
        int n = ResultSetFormatter.consume((ResultSet)rs);
        AbstractTestDynamicDataset.assertEquals((long)expected, (long)n);
    }
}

