/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDatasetGraphTests {
    protected abstract DatasetGraph emptyDataset();

    @Test
    public void create_1() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Assert.assertNotNull((Object)dsg.getDefaultGraph());
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
    }

    @Test
    public void quad_01() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        Assert.assertTrue((boolean)dsg.contains(quad));
        Iterator iter = dsg.find(quad);
        Assert.assertTrue((boolean)iter.hasNext());
        Quad quad2 = (Quad)iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((Object)quad, (Object)quad2);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertFalse((boolean)dsg.getGraph(NodeFactory.createURI((String)"g")).isEmpty());
    }

    @Test
    public void quad_02() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        dsg.containsGraph(NodeFactory.createURI((String)"g"));
        dsg.delete(quad);
        Assert.assertTrue((boolean)dsg.isEmpty());
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(NodeFactory.createURI((String)"g")).isEmpty());
    }

    @Test
    public void quad_03() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad1 = SSE.parseQuad((String)"(quad <g> <s> <p> <o1>)");
        Quad quad2 = SSE.parseQuad((String)"(quad <g> <s> <p> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        dsg.deleteAny(NodeFactory.createURI((String)"g"), NodeFactory.createURI((String)"s"), null, null);
        Assert.assertFalse((boolean)dsg.contains(quad1));
        Assert.assertFalse((boolean)dsg.contains(quad2));
    }

    @Test
    public void quad_04() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad1 = SSE.parseQuad((String)"(quad <g> <s> <p> <o1>)");
        Quad quad2 = SSE.parseQuad((String)"(quad <g> <s> <p> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        Iterator iter = dsg.find(NodeFactory.createURI((String)"g"), NodeFactory.createURI((String)"s"), null, null);
        Assert.assertTrue((boolean)iter.hasNext());
        Set x = Iter.iter((Iterator)iter).toSet();
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(quad1));
        Assert.assertTrue((boolean)x.contains(quad2));
    }

    @Test
    public void quad_05() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad1 = SSE.parseQuad((String)"(quad <g> <s> <p> <o1>)");
        Quad quad2 = SSE.parseQuad((String)"(quad <g> <s> <p> <o2>)");
        Node g = SSE.parseNode((String)"<g>");
        Node s = SSE.parseNode((String)"<s>");
        Node p = SSE.parseNode((String)"<p>");
        Node o1 = SSE.parseNode((String)"<o1>");
        Node o2 = SSE.parseNode((String)"<o2>");
        dsg.add(g, s, p, o1);
        Assert.assertTrue((boolean)dsg.contains(quad1));
        Assert.assertTrue((boolean)dsg.contains(g, s, p, o1));
        Assert.assertFalse((boolean)dsg.contains(g, s, p, o2));
    }

    @Test
    public void graph_00() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Node gn = NodeFactory.createURI((String)"g");
        Graph g = GraphFactory.createDefaultGraph();
        g.add(SSE.parseTriple((String)"(<s> <p> <o>)"));
        dsg.addGraph(gn, g);
        Assert.assertTrue((boolean)dsg.containsGraph(gn));
    }

    @Test
    public void graph_01() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Node g = NodeFactory.createURI((String)"g");
        Triple t = SSE.parseTriple((String)"(<s> <p> <o>)");
        dsg.getGraph(g).add(t);
        Assert.assertTrue((boolean)dsg.getGraph(g).contains(t));
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        Iterator iter = dsg.find(null, null, null, null);
        Assert.assertTrue((boolean)iter.hasNext());
        Quad quad2 = (Quad)iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((Object)quad, (Object)quad2);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertFalse((boolean)dsg.getGraph(NodeFactory.createURI((String)"g")).isEmpty());
    }

    @Test
    public void graph_02() {
        Node g = NodeFactory.createURI((String)"g");
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        Triple t = SSE.parseTriple((String)"(<s> <p> <o>)");
        dsg.getGraph(g).delete(t);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(NodeFactory.createURI((String)"g")).isEmpty());
        Assert.assertFalse((boolean)dsg.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    @Test
    public void graph_03() {
        Node g = NodeFactory.createURI((String)"g");
        DatasetGraph dsg = this.emptyDataset();
        Graph data = SSE.parseGraph((String)"(graph (<s> <p> <o>))");
        dsg.addGraph(g, data);
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        Assert.assertTrue((boolean)dsg.contains(quad));
    }

    @Test
    public void find_01() {
        Node g1 = NodeFactory.createURI((String)"g1");
        DatasetGraph dsg = this.emptyDataset();
        Quad quad1 = SSE.parseQuad((String)"(quad <g1> <s1> <p1> <o1>)");
        Quad quad2 = SSE.parseQuad((String)"(quad <g2> <s2> <p2> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        List quads = Iter.toList((Iterator)dsg.find(g1, null, null, null));
        Assert.assertEquals((long)1L, (long)quads.size());
        Quad q = (Quad)quads.get(0);
        Assert.assertEquals((Object)quad1, (Object)q);
    }

    @Test
    public void deleteAny_01() {
        DatasetGraph dsg = this.emptyDataset();
        Node subject = NodeFactory.createURI((String)"http://example/s");
        Node predicate = NodeFactory.createURI((String)"http://example/p");
        Node object = NodeFactory.createAnon();
        dsg.add(new Quad(Quad.defaultGraphIRI, subject, predicate, object));
        dsg.deleteAny(Node.ANY, subject, null, null);
    }

    @Test
    public void deleteAny_02() {
        DatasetGraph dsg = this.emptyDataset();
        Node subject = NodeFactory.createURI((String)"http://example/s");
        Node predicate = NodeFactory.createURI((String)"http://example/p");
        Node object1 = NodeFactory.createAnon();
        Node object2 = NodeFactory.createAnon();
        Node graph = NodeFactory.createURI((String)"http://example/g");
        dsg.add(graph, subject, predicate, object1);
        dsg.add(graph, subject, predicate, object2);
        dsg.deleteAny(Quad.defaultGraphIRI, null, null, null);
        List quads = Iter.toList((Iterator)dsg.find(graph, null, null, null));
        Assert.assertEquals((long)2L, (long)quads.size());
        dsg.deleteAny(graph, null, null, null);
        quads = Iter.toList((Iterator)dsg.find(graph, null, null, null));
        Assert.assertEquals((long)0L, (long)quads.size());
    }

    @Test
    public void clear_01() {
        DatasetGraph dsg = this.emptyDataset();
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        Node gn = SSE.parseNode((String)"<g>");
        Assert.assertTrue((boolean)dsg.isEmpty());
        dsg.add(quad);
        Assert.assertFalse((boolean)dsg.isEmpty());
        Assert.assertTrue((boolean)dsg.containsGraph(gn));
        dsg.clear();
        Assert.assertTrue((boolean)dsg.isEmpty());
        Assert.assertFalse((boolean)dsg.containsGraph(gn));
    }
}

