/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.api;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.sse.SSE;
import org.apache.jena.atlas.lib.Lib;
import org.junit.Assert;
import org.junit.Test;

public class TestQueryExecutionTimeout2 {
    private static String prefix = "PREFIX f:       <http://example/ns#>\nPREFIX afn:     <http://jena.hpl.hp.com/ARQ/function#>\n";
    static Graph g = SSE.parseGraph((String)"(graph (<s> <p> 1) (<s> <p> 2) (<s> <p> 3) (<s> <p> 4) (<s> <p> 5) (<s> <p> 6) (<s> <p> 7) (<s> <p> 8) (<s> <p> 9) (<s> <p> 10) (<s> <p> 11) (<s> <p> 12))");
    static DatasetGraph dsg = DatasetGraphFactory.createOneGraph((Graph)g);
    static Dataset ds = DatasetFactory.create((DatasetGraph)dsg);

    private static void noException(ResultSet rs) {
        ResultSetFormatter.consume((ResultSet)rs);
    }

    private static void exceptionExpected(ResultSet rs) {
        try {
            ResultSetFormatter.consume((ResultSet)rs);
            Assert.fail((String)"QueryCancelledException expected");
        }
        catch (QueryCancelledException queryCancelledException) {
            // empty catch block
        }
    }

    @Test
    public void timeout_30() {
        TestQueryExecutionTimeout2.test2(200L, 20L, 50, true);
    }

    @Test
    public void timeout_31() {
        TestQueryExecutionTimeout2.test2(200L, 50L, 20, false);
    }

    @Test
    public void timeout_32() {
        TestQueryExecutionTimeout2.test2(100L, 500L, 200, false);
    }

    @Test
    public void timeout_33() {
        TestQueryExecutionTimeout2.test2(150L, -1L, 200, false);
    }

    @Test
    public void timeout_34() {
        TestQueryExecutionTimeout2.test2(10L, 40L, 100, true);
    }

    @Test
    public void timeout_35() {
        TestQueryExecutionTimeout2.test2(-1L, 20L, 50, true);
    }

    @Test
    public void timeout_36() {
        TestQueryExecutionTimeout2.test2(-1L, 50L, 20, false);
    }

    @Test
    public void timeout_37() {
        TestQueryExecutionTimeout2.test2(200L, 200L, 50, false);
    }

    @Test
    public void timeout_38() {
        TestQueryExecutionTimeout2.test2(200L, -1L, 50, false);
    }

    private static void test2(long timeout1, long timeout2, int delay, boolean exceptionExpected) {
        try (QueryExecution qExec = QueryExecutionFactory.create((String)(prefix + "SELECT * { ?s ?p ?o }"), (Dataset)ds);){
            qExec.setTimeout(timeout1, timeout2);
            ResultSet rs = qExec.execSelect();
            Binding b1 = rs.nextBinding();
            Lib.sleep((int)delay);
            if (exceptionExpected) {
                TestQueryExecutionTimeout2.exceptionExpected(rs);
            } else {
                TestQueryExecutionTimeout2.noException(rs);
            }
        }
    }
}

