/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.api;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestAPI
extends BaseTest {
    private static final String ns = "http://example/ns#";
    static Model m = GraphFactory.makeJenaDefaultModel();
    static Resource r1 = m.createResource();
    static Property p1 = m.createProperty("http://example/ns#p1");
    static Property p2 = m.createProperty("http://example/ns#p2");
    static Property p3 = m.createProperty("http://example/ns#p3");

    @Test
    public void testInitialBindingsConstruct1() {
        try (QueryExecution qExec = this.makeQExec("CONSTRUCT {?s ?p ?z} {?s ?p 'x1'}");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("z", (RDFNode)m.createLiteral("zzz"));
            qExec.setInitialBinding((QuerySolution)init);
            Model r = qExec.execConstruct();
            TestAPI.assertTrue((String)"Empty model", (r.size() > 0L ? 1 : 0) != 0);
            Property p1 = m.createProperty("http://example/ns#p1");
            TestAPI.assertTrue((String)"Empty model", (boolean)r.contains(null, p1, init.get("z")));
        }
    }

    @Test
    public void testInitialBindingsConstruct2() {
        try (QueryExecution qExec = this.makeQExec("CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("o", (RDFNode)m.createLiteral("x1"));
            qExec.setInitialBinding((QuerySolution)init);
            Model r = qExec.execConstruct();
            TestAPI.assertTrue((String)"Empty model", (r.size() > 0L ? 1 : 0) != 0);
            Property p1 = m.createProperty("http://example/ns#p1");
            TestAPI.assertTrue((String)"Empty model", (boolean)r.contains(null, p1, init.get("x1")));
        }
    }

    @Test
    public void test_API1() {
        try (QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");){
            ResultSet rs = qExec.execSelect();
            TestAPI.assertTrue((String)"No results", (boolean)rs.hasNext());
            QuerySolution qs = rs.nextSolution();
            Resource qr = qs.getResource("s");
            TestAPI.assertSame((String)"Not the same model as queried", (Object)qr.getModel(), (Object)m);
        }
    }

    @Test
    public void testInitialBindings0() {
        QuerySolutionMap smap1 = new QuerySolutionMap();
        QuerySolutionMap smap2 = new QuerySolutionMap();
        smap1.add("o", (RDFNode)m.createLiteral("y1"));
        smap2.addAll(smap1);
        TestAPI.assertTrue((boolean)smap2.contains("o"));
        smap2.clear();
        TestAPI.assertFalse((boolean)smap2.contains("o"));
        TestAPI.assertTrue((boolean)smap1.contains("o"));
        QuerySolutionMap smap3 = new QuerySolutionMap();
        smap2.addAll((QuerySolution)smap1);
        TestAPI.assertTrue((boolean)smap2.contains("o"));
    }

    @Test
    public void testInitialBindings1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("o", (RDFNode)m.createLiteral("y1"));
        qExec.setInitialBinding((QuerySolution)init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((String)"Initial binding didn't restrict query properly", (long)1L, (long)count);
    }

    @Test
    public void testInitialBindings2() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", (RDFNode)m.createLiteral("zzz"));
        qExec.setInitialBinding((QuerySolution)init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((String)"Initial binding restricted query improperly", (long)3L, (long)count);
    }

    @Test
    public void testInitialBindings3() {
        try (QueryExecution qExec = this.makeQExec("SELECT * {?s ?p 'x1'}");){
            QuerySolutionMap init = new QuerySolutionMap();
            init.add("z", (RDFNode)m.createLiteral("zzz"));
            qExec.setInitialBinding((QuerySolution)init);
            ResultSet rs = qExec.execSelect();
            QuerySolution qs = rs.nextSolution();
            TestAPI.assertTrue((String)"Initial setting not set correctly now", (boolean)qs.getLiteral("z").getLexicalForm().equals("zzz"));
        }
    }

    @Test
    public void testInitialBindings4() {
        String queryString = "PREFIX : <http://example/ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT * \nWHERE { \n    ?x :p1 ?z .    NOT EXISTS { \n        ?x rdfs:label ?z . \n    }\n}";
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);){
            QuerySolutionMap map = new QuerySolutionMap();
            map.add("this", (RDFNode)OWL.Thing);
            qexec.setInitialBinding((QuerySolution)map);
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.nextSolution();
            }
        }
    }

    @Test
    public void testInitialBindings5() {
        Query query = QueryFactory.create((String)"ASK\nWHERE {\n    FILTER (?a = <http://constant>) .\n}");
        Model model = ModelFactory.createDefaultModel();
        model.add(OWL.Thing, RDF.type, (RDFNode)OWL.Class);
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("a", (RDFNode)ResourceFactory.createResource((String)"http://constant"));
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
        boolean result = qexec.execAsk();
        TestAPI.assertTrue((boolean)result);
    }

    @Test
    public void testInitialBindings6() {
        Query query = QueryFactory.create((String)"ASK\nWHERE {\n    FILTER (?a = ?b) .\n}");
        Model model = ModelFactory.createDefaultModel();
        model.add(OWL.Thing, RDF.type, (RDFNode)OWL.Class);
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("a", (RDFNode)ResourceFactory.createTypedLiteral((Object)Boolean.TRUE));
        initialBinding.add("b", (RDFNode)ResourceFactory.createTypedLiteral((Object)Boolean.TRUE));
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model, (QuerySolution)initialBinding);
        boolean result = qexec.execAsk();
        TestAPI.assertTrue((boolean)result);
    }

    @Test
    public void testReuseQueryObject1() {
        String queryString = "SELECT * {?s ?p ?o}";
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((long)3L, (long)count);
        qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        count = this.queryAndCount(qExec);
        TestAPI.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testReuseQueryObject2() {
        QuerySolution qs;
        ResultSet rs;
        String queryString = "SELECT (count(?s) AS ?c) {?s ?p ?o} GROUP BY ?s";
        Query q = QueryFactory.create((String)queryString);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);){
            rs = qExec.execSelect();
            qs = rs.nextSolution();
            TestAPI.assertEquals((long)3L, (long)qs.getLiteral("c").getInt());
        }
        qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        var4_4 = null;
        try {
            rs = qExec.execSelect();
            qs = rs.nextSolution();
            TestAPI.assertEquals((long)3L, (long)qs.getLiteral("c").getInt());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (qExec != null) {
                if (var4_4 != null) {
                    try {
                        qExec.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    qExec.close();
                }
            }
        }
    }

    @Test
    public void testConstructRejectsBadTriples1() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { ?o ?p ?s }";
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        Model resultModel = qExec.execConstruct();
        TestAPI.assertEquals((long)0L, (long)resultModel.size());
    }

    @Test
    public void testConstructRejectsBadTriples2() {
        String queryString = "CONSTRUCT { ?s ?p ?o } WHERE { ?o ?p ?s }";
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        Iterator ts = qExec.execConstructTriples();
        long count = 0L;
        while (ts.hasNext()) {
            ++count;
            ts.next();
        }
        TestAPI.assertEquals((long)0L, (long)count);
    }

    private QueryExecution makeQExec(String queryString) {
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);
        return qExec;
    }

    private int queryAndCount(String queryString) {
        QueryExecution qExec = this.makeQExec(queryString);
        return this.queryAndCount(qExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryAndCount(QueryExecution qExec) {
        try {
            ResultSet rs = qExec.execSelect();
            int n = ResultSetFormatter.consume((ResultSet)rs);
            return n;
        }
        finally {
            qExec.close();
        }
    }

    static {
        m.add(r1, p1, "x1");
        m.add(r1, p2, "X2");
        m.add(r1, p3, "y1");
    }
}

