/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.uniongraph;

import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.junit.Test;

public class TestUnionGraph
extends BaseTest {
    static String x1 = StrUtils.strjoinNL((String[])new String[]{"(dataset", "  (graph (<s> <p> <o>) (<x> <p> <o>) (<x2> <p> <o1>) (<x2> <p> <o3>) (<x2> <p> <o4>))", "  (graph <g1> (triple <s1> <p1> <o1>))", "  (graph <g2> (triple <s2> <p2> <o2>))", "  (graph <g3> (triple <s2> <p2> <o2>))", ")"});
    static DatasetGraph dsg1 = BuilderGraph.buildDataset((Item)SSE.parse((String)x1));
    static String x2 = StrUtils.strjoinNL((String[])new String[]{"(dataset", "  (graph (<s> <p1> 10) (<s> <p1> 11) (<s> <p2> 20) )", "  (graph <g1> (<s1> <p1> <z>) (<z> <p2> 1) )", "  (graph <g2> (<s1> <p1> <z>) (<z> <p2> 2) )", "  (graph <g3> (<s>  <p1> 10))", ")"});
    static DatasetGraph dsg2 = BuilderGraph.buildDataset((Item)SSE.parse((String)x2));

    @Test
    public void union_graph_triples_1() {
        List<Binding> results = TestUnionGraph.exec("(graph <" + Quad.unionGraph + "> (bgp (<s2> ?p ?o)))", false, dsg1);
        TestUnionGraph.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void union_graph_triples_2() {
        List<Binding> results = TestUnionGraph.exec("(graph <" + Quad.unionGraph + "> (bgp (<x2> ?p ?o)))", false, dsg1);
        TestUnionGraph.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void union_graph_quads_1() {
        List<Binding> results = TestUnionGraph.exec("(graph <" + Quad.unionGraph + "> (bgp (<s2> ?p ?o)))", true, dsg1);
        TestUnionGraph.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void union_graph_quads_2() {
        List<Binding> results = TestUnionGraph.exec("(graph <" + Quad.unionGraph + "> (bgp (<x2> ?p ?o)))", true, dsg1);
        TestUnionGraph.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void union_graph_triples_10() {
        List<Binding> results = TestUnionGraph.exec("(graph <" + Quad.unionGraph + "> (bgp (<s1> ?p ?z) (?z ?q ?o) ))", false, dsg2);
        TestUnionGraph.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void union_graph_quads_10() {
        List<Binding> results = TestUnionGraph.exec("(graph <" + Quad.unionGraph + "> (bgp (<s1> ?p ?z) (?z ?q ?o) ))", false, dsg2);
        TestUnionGraph.assertEquals((long)2L, (long)results.size());
    }

    private static List<Binding> exec(String pattern, boolean applyQuad, DatasetGraph dsg) {
        Op op = SSE.parseOp((String)pattern);
        if (applyQuad) {
            op = Algebra.toQuadForm((Op)op);
        }
        Op op2 = Algebra.unionDefaultGraph((Op)op);
        QueryIterator qIter = Algebra.exec((Op)op, (DatasetGraph)dsg1);
        return Iter.toList((Iterator)qIter);
    }
}

