/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.uniongraph;

import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.uniongraph.TestUnionGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public abstract class AbstractTestUnionTransform
extends BaseTest {
    @Test
    public void union_1() {
        List<Binding> results = this.exec("(bgp (?s ?p ?o))");
        AbstractTestUnionTransform.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void union_2() {
        List<Binding> results = this.exec("(bgp (<s2> ?p ?o))");
        AbstractTestUnionTransform.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void union_3() {
        List<Binding> results = this.exec("(graph <g1> (bgp (<s1> ?p ?o)))");
        AbstractTestUnionTransform.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void union_4() {
        List<Binding> results = this.exec("(graph <g1> (bgp (<s2> ?p ?o)))");
        AbstractTestUnionTransform.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void union_5() {
        List<Binding> results = this.exec("(graph <g2> (bgp (<s2> ?p ?o)))");
        AbstractTestUnionTransform.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void union_6() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphIRI + "> (bgp (<s2> ?p ?o)))");
        AbstractTestUnionTransform.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void union_7() {
        List<Binding> results = this.exec("(graph <" + Quad.defaultGraphIRI + "> (bgp (<x2> ?p ?o)))");
        AbstractTestUnionTransform.assertEquals((long)3L, (long)results.size());
    }

    private List<Binding> exec(String pattern) {
        Op op = this.op(pattern);
        QueryIterator qIter = Algebra.exec((Op)op, (DatasetGraph)TestUnionGraph.dsg1);
        return Iter.toList((Iterator)qIter);
    }

    protected abstract Op op(String var1);
}

