/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.optimize.AbstractTestTransform;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformTopN;
import org.apache.jena.atlas.lib.StrUtils;
import org.junit.Test;

public class TestTransformTopN
extends AbstractTestTransform {
    @Test
    public void topN_01() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (order (?z)", "    (bgp (triple ?s ?p ?z)) ))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(top (5 ?z)", "  (bgp (triple ?s ?p ?z)))"});
        this.test(input, output);
    }

    @Test
    public void topN_02() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (project (?z)", "    (order (?z)", "      (bgp (triple ?s ?p ?z)) )))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(project (?z)", "  (top (5 ?z)", "    (bgp (triple ?s ?p ?z)) ))"});
        this.test(input, output);
    }

    @Test
    public void topN_03() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (project (?s ?z)", "    (order (?z ?s)", "      (bgp (triple ?s ?p ?z)) )))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(project (?s ?z)", "  (top (5 ?z ?s)", "    (bgp (triple ?s ?p ?z)) ))"});
        this.test(input, output);
    }

    @Test
    public void topN_04() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (project (?s ?z)", "    (order (?z)", "      (bgp (triple ?s ?p ?z)) )))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(project (?s ?z)", "  (top (5 ?z)", "    (bgp (triple ?s ?p ?z))))"});
        this.test(input, output);
    }

    @Test
    public void topN_05() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", " (project (?z)", "   (order (?z ?s)", "     (bgp (triple ?s ?p ?z)) )))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(project (?z)", "  (top (5 ?z ?s)", "    (bgp (triple ?s ?p ?z)) ))"});
        this.test(input, output);
    }

    @Test
    public void topN_06() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (project (?s ?p)", "    (order (?z ?s)", "      (bgp (triple ?s ?p ?z)) )))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(project (?s ?p)", "  (top (5 ?z ?s)", "    (bgp (triple ?s ?p ?z)) ))"});
        this.test(input, output);
    }

    @Test
    public void topN_07() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (project (?s ?p ?z)", "    (order (?z ?s)", "      (bgp (triple ?s ?p ?z)) )))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(project (?s ?p ?z)", "  (top (5 ?z ?s)", "   (bgp (triple ?s ?p ?z)) ))"});
        this.test(input, output);
    }

    @Test
    public void topN_11() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (distinct", "    (order (?z)", "      (bgp (triple ?s ?p ?z)) )))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(top (5 ?z)", "  (distinct", "    (bgp (triple ?s ?p ?z)) ))"});
        this.test(input, output);
    }

    @Test
    public void topN_12() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (distinct", "    (project (?s ?z)", "      (order (?z ?s)", "        (bgp (triple ?s ?p ?z)) ))))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(top (5 ?z ?s)", "  (distinct", "    (project (?s ?z)", "      (bgp (triple ?s ?p ?z)) )))"});
        this.test(input, output);
    }

    @Test
    public void topN_13() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (distinct", "    (project (?z)", "      (order (?z)", "        (bgp (triple ?s ?p ?z)) ))))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(top (5 ?z)", "  (distinct", "    (project (?z)", "      (bgp (triple ?s ?p ?z)) )))"});
        this.test(input, output);
    }

    @Test
    public void topN_14() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (distinct", "    (project (?s ?z)", "      (order (?z)", "        (bgp (triple ?s ?p ?z)) ))))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(top (5 ?z)", "  (distinct", "    (project (?s ?z)", "      (bgp (triple ?s ?p ?z)) )))"});
        this.test(input, output);
    }

    @Test
    public void topN_15() {
        String input;
        String output = input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (distinct", "    (project (?z)", "      (order (?z ?s)", "        (bgp (triple ?s ?p ?z)) ))))"});
        this.test(input, output);
    }

    @Test
    public void topN_16() {
        String input;
        String output = input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (distinct", "    (project (?s ?p)", "      (order (?z ?s)", "        (bgp (triple ?s ?p ?z)) ))))"});
        this.test(input, output);
    }

    @Test
    public void topN_17() {
        String input = StrUtils.strjoinNL((String[])new String[]{"(slice _ 5", "  (distinct", "    (project (?s ?p ?z)", "      (order (?z ?s)", "        (bgp (triple ?s ?p ?z)) ))))"});
        String output = StrUtils.strjoinNL((String[])new String[]{"(top (5 ?z ?s)", "  (distinct", "    (project (?s ?p ?z)", "      (bgp (triple ?s ?p ?z)) )))"});
        this.test(input, output);
    }

    @Test
    public void topN_query_01() {
        String output = StrUtils.strjoinNL((String[])new String[]{"    (project (?s)", " (order (?p ?o)", "   (bgp (triple ?s ?p ?o))))"});
        this.testQuery("SELECT ?s { ?s ?p ?o } ORDER BY ?p ?o", output);
    }

    @Test
    public void topN_query_02() {
        String output = StrUtils.strjoinNL((String[])new String[]{"  (slice 1 _", "  (project (?s)", "    (top (6 ?p ?o)", "      (bgp (triple ?s ?p ?o)))))"});
        this.testQuery("SELECT ?s { ?s ?p ?o } ORDER BY ?p ?o OFFSET 1 LIMIT 5", output);
    }

    @Test
    public void topN_query_03() {
        String output = StrUtils.strjoinNL((String[])new String[]{"(slice 1 _", "  (project (?s)", "    (top (6 ?p ?o)", "      (bgp (triple ?s ?p ?o)))))"});
        this.testQuery("SELECT ?s { ?s ?p ?o } ORDER BY ?p ?o OFFSET 1 LIMIT 5", output);
    }

    @Test
    public void topN_query_04() {
        String output = StrUtils.strjoinNL((String[])new String[]{"(slice 1 _", "  (project (?s)", "    (top (6 ?p ?o)", "      (bgp (triple ?s ?p ?o)))))"});
        this.testQuery("SELECT ?s { ?s ?p ?o } ORDER BY ?p ?o OFFSET 1 LIMIT 5", output);
    }

    private void test(String input, String output) {
        TransformTopN transform = new TransformTopN();
        this.testOp(input, (Transform)transform, output);
    }

    private void testQuery(String input, String output) {
        TransformTopN transform = new TransformTopN();
        this.testQuery(input, (Transform)transform, output);
    }
}

