/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.main.QueryEngineMain;
import com.hp.hpl.jena.sparql.resultset.ResultSetCompare;
import com.hp.hpl.jena.sparql.resultset.TextOutput;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSemanticEquivalence {
    private static Dataset implJoin;

    @BeforeClass
    public static void setup() {
        implJoin = DatasetFactory.createMem();
        Node a = NodeFactory.createURI((String)"http://a");
        Node b = NodeFactory.createURI((String)"http://b");
        Node c = NodeFactory.createURI((String)"http://c");
        Node p1 = NodeFactory.createURI((String)"http://p1");
        Node p2 = NodeFactory.createURI((String)"http://p2");
        Node pSelf = NodeFactory.createURI((String)"http://self");
        Node o = NodeFactory.createLiteral((String)"object");
        DatasetGraph dsg = implJoin.asDatasetGraph();
        dsg.add(Quad.defaultGraphNodeGenerated, a, p1, o);
        dsg.add(Quad.defaultGraphNodeGenerated, a, p2, o);
        dsg.add(Quad.defaultGraphNodeGenerated, b, p1, o);
        dsg.add(Quad.defaultGraphNodeGenerated, b, p2, o);
        dsg.add(Quad.defaultGraphNodeGenerated, c, p1, o);
        Assert.assertFalse((boolean)ARQ.isFalse((Symbol)ARQ.optFilterImplicitJoin));
        Assert.assertFalse((boolean)ARQ.isFalse((Symbol)ARQ.optImplicitLeftJoin));
    }

    @AfterClass
    public static void teardown() {
        if (implJoin != null) {
            implJoin.close();
            implJoin = null;
        }
        Assert.assertFalse((boolean)ARQ.isFalse((Symbol)ARQ.optFilterImplicitJoin));
        Assert.assertFalse((boolean)ARQ.isFalse((Symbol)ARQ.optImplicitLeftJoin));
    }

    @Test
    public void implicitJoinEvaluation1() {
        String query = "SELECT * WHERE { ?x <http://p1> ?o1 . ?y <http://p2> ?o2 . FILTER(?x = ?y) }";
        TestSemanticEquivalence.test(query, implJoin, ARQ.optFilterImplicitJoin, 2);
        String alg1 = "(filter (= ?x ?y) (bgp (?x <http://p1> ?o1)(?y <http://p2> ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 2);
        String alg2 = "(filter (= ?y ?x) (bgp (?x <http://p1> ?o1)(?y <http://p2> ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg2, implJoin, ARQ.optFilterImplicitJoin, 2);
    }

    @Test
    public void implicitJoinEvaluation2() {
        String query = "SELECT * WHERE { ?x <http://p1> ?o1 . ?y <http://noSuchPredicate> ?o2 . FILTER(?x = ?y) }";
        TestSemanticEquivalence.test(query, implJoin, ARQ.optFilterImplicitJoin, 0);
        String alg1 = "(filter (= ?x ?y) (bgp (?x <http://p1> ?o1)(?y <http://noSuchPredicate> ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 0);
        String alg2 = "(filter (= ?y ?x) (bgp (?x <http://p1> ?o1)(?y <http://noSuchPredicate> ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 0);
    }

    @Test
    public void implicitJoinEvaluation3() {
        String query = "SELECT * WHERE { ?x <http://p1> ?o1 . FILTER(?x = ?y) }";
        TestSemanticEquivalence.test(query, implJoin, ARQ.optFilterImplicitJoin, 0);
        String alg1 = "(filter (= ?x ?y) (bgp (?x <http://p1> ?o1)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 0);
        String alg2 = "(filter (= ?y ?x) (bgp (?x <http://p1> ?o1)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optFilterImplicitJoin, 0);
    }

    @Test
    public void implicitLeftJoinEvaluation1() {
        String query = "SELECT * WHERE { ?x <http://p1> ?o1 . OPTIONAL { ?y <http://p2> ?o2 . FILTER(?x = ?y) } }";
        TestSemanticEquivalence.test(query, implJoin, ARQ.optImplicitLeftJoin, 3);
        String alg1 = "(leftjoin (bgp (?x <http://p1> ?o1)) (bgp (?y <http://p2> ?o2)) (= ?x ?y))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optImplicitLeftJoin, 3);
        String alg2 = "(leftjoin (bgp (?x <http://p1> ?o1)) (bgp (?y <http://p2> ?o2)) (= ?y ?x))";
        TestSemanticEquivalence.testAsAlgebra(alg2, implJoin, ARQ.optImplicitLeftJoin, 3);
    }

    @Test
    public void implicitLeftJoinEvaluation2() {
        String query = "SELECT * WHERE { ?x <http://p1> ?o1 . OPTIONAL { ?y <http://p2> ?o2 . FILTER(?x = ?y && ?o1 >= ?o2) } }";
        TestSemanticEquivalence.test(query, implJoin, ARQ.optImplicitLeftJoin, 3);
        String alg1 = "(leftjoin (bgp (?x <http://p1> ?o1)) (bgp (?y <http://p2> ?o2)) (&& (= ?x ?y)(> ?o1 ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optImplicitLeftJoin, 3);
        String alg2 = "(leftjoin (bgp (?x <http://p1> ?o1)) (bgp (?y <http://p2> ?o2)) (&& (= ?y ?x)(> ?o1 ?o2)))";
        TestSemanticEquivalence.testAsAlgebra(alg2, implJoin, ARQ.optImplicitLeftJoin, 3);
    }

    @Test
    public void implicitLeftJoinEvaluation3() {
        String query = "SELECT * WHERE { ?x ?p ?o . OPTIONAL { ?y ?p1 ?o1 . ?y ?p2 ?z . FILTER(?x = ?y) FILTER(?x = ?z) FILTER(?y = ?z) } }";
        TestSemanticEquivalence.test(query, implJoin, ARQ.optImplicitLeftJoin, 5);
        String alg1 = "(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((= ?x ?y) (= ?x ?z) (= ?y ?z)))";
        TestSemanticEquivalence.testAsAlgebra(alg1, implJoin, ARQ.optImplicitLeftJoin, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String queryStr, Dataset ds, Symbol opt, int expected) {
        Query q = QueryFactory.create((String)queryStr);
        if (!q.isSelectType()) {
            Assert.fail((String)"Only SELECT queries are testable with this method");
        }
        Op op = Algebra.compile((Query)q);
        boolean isEnabled = ARQ.isTrue((Symbol)opt);
        boolean isDisabled = ARQ.isFalse((Symbol)opt);
        try {
            ResultSetRewindable rsOpt;
            ResultSetRewindable rs;
            ARQ.set((Symbol)opt, (boolean)false);
            try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Dataset)ds);){
                rs = ResultSetFactory.makeRewindable((ResultSet)qe.execSelect());
                if (expected != rs.size()) {
                    System.err.println("Non-optimized results not as expected");
                    TextOutput output = new TextOutput((SerializationContext)null);
                    output.format((OutputStream)System.out, (ResultSet)rs);
                    rs.reset();
                }
                Assert.assertEquals((long)expected, (long)rs.size());
            }
            ARQ.set((Symbol)opt, (boolean)true);
            try (QueryExecution qeOpt = QueryExecutionFactory.create((Query)q, (Dataset)ds);){
                rsOpt = ResultSetFactory.makeRewindable((ResultSet)qeOpt.execSelect());
                if (expected != rsOpt.size()) {
                    System.err.println("Optimized results not as expected");
                    TextOutput output = new TextOutput((SerializationContext)null);
                    output.format((OutputStream)System.out, (ResultSet)rsOpt);
                    rsOpt.reset();
                }
                Assert.assertEquals((long)expected, (long)rsOpt.size());
            }
            Assert.assertTrue((boolean)ResultSetCompare.isomorphic((ResultSet)rs, (ResultSet)rsOpt));
        }
        finally {
            if (isEnabled) {
                ARQ.set((Symbol)opt, (boolean)true);
            } else if (isDisabled) {
                ARQ.set((Symbol)opt, (boolean)false);
            } else {
                ARQ.unset((Symbol)opt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testAsAlgebra(String algStr, Dataset ds, Symbol opt, int expected) {
        Op op = SSE.parseOp((String)algStr);
        ArrayList<String> vars = new ArrayList<String>();
        for (Var v : OpVars.visibleVars((Op)op)) {
            vars.add(v.getName());
        }
        boolean isEnabled = ARQ.isTrue((Symbol)opt);
        boolean isDisabled = ARQ.isFalse((Symbol)opt);
        try {
            ARQ.set((Symbol)opt, (boolean)false);
            QueryEngineMain engine = new QueryEngineMain(op, ds.asDatasetGraph(), BindingFactory.binding(), ARQ.getContext());
            QueryIterator iter = engine.eval(op, ds.asDatasetGraph(), BindingFactory.binding(), ARQ.getContext());
            ResultSetRewindable rs = ResultSetFactory.makeRewindable((ResultSet)new ResultSetStream(vars, ModelFactory.createDefaultModel(), (Iterator)iter));
            if (expected != rs.size()) {
                System.err.println("Non-optimized results not as expected");
                TextOutput output = new TextOutput((SerializationContext)null);
                output.format((OutputStream)System.out, (ResultSet)rs);
                rs.reset();
            }
            Assert.assertEquals((long)expected, (long)rs.size());
            iter.close();
            ARQ.set((Symbol)opt, (boolean)true);
            engine = new QueryEngineMain(op, ds.asDatasetGraph(), BindingFactory.binding(), ARQ.getContext());
            QueryIterator iterOpt = engine.eval(op, ds.asDatasetGraph(), BindingFactory.binding(), ARQ.getContext());
            ResultSetRewindable rsOpt = ResultSetFactory.makeRewindable((ResultSet)new ResultSetStream(vars, ModelFactory.createDefaultModel(), (Iterator)iterOpt));
            if (expected != rsOpt.size()) {
                System.err.println("Optimized results not as expected");
                TextOutput output = new TextOutput((SerializationContext)null);
                output.format((OutputStream)System.out, (ResultSet)rsOpt);
                rsOpt.reset();
            }
            Assert.assertEquals((long)expected, (long)rsOpt.size());
            iterOpt.close();
            Assert.assertTrue((boolean)ResultSetCompare.isomorphic((ResultSet)rs, (ResultSet)rsOpt));
        }
        finally {
            if (isEnabled) {
                ARQ.set((Symbol)opt, (boolean)true);
            } else if (isDisabled) {
                ARQ.set((Symbol)opt, (boolean)false);
            } else {
                ARQ.unset((Symbol)opt);
            }
        }
    }
}

